/*
 * Decompiled with CFR 0.152.
 */
package cech12.solarcooker.client;

import cech12.solarcooker.block.AbstractSolarCookerBlock;
import cech12.solarcooker.blockentity.SolarCookerBlockEntity;
import cech12.solarcooker.init.ModBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SolarCookerBlockEntityRenderer
implements BlockEntityRenderer<SolarCookerBlockEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("solarcooker", "textures/entity/solar_cooker.png");
    private static final LayerDefinition innerCube = SolarCookerBlockEntityRenderer.createInnerLayerDefinition();
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart inner;
    private final ModelPart lock;

    private static LayerDefinition createInnerLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("inner", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171481_(3.0f, 2.0f, 3.0f, 10.0f, 8.0f, 10.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public SolarCookerBlockEntityRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        ModelPart modelpart = rendererProvider.m_173582_(ModelLayers.f_171275_);
        this.bottom = modelpart.m_171324_("bottom");
        this.lid = modelpart.m_171324_("lid");
        this.lock = modelpart.m_171324_("lock");
        this.inner = innerCube.m_171564_().m_171324_("inner");
    }

    public void render(SolarCookerBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Level world = blockEntity.m_58904_();
        boolean isInWorld = world != null;
        BlockState blockstate = isInWorld ? blockEntity.m_58900_() : (BlockState)((Block)ModBlocks.SOLAR_COOKER.get()).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        Block block = blockstate.m_60734_();
        if (block instanceof AbstractSolarCookerBlock) {
            ItemStack stack;
            matrixStackIn.m_85836_();
            float f = ((Direction)blockstate.m_61143_((Property)AbstractSolarCookerBlock.FACING)).m_122435_();
            matrixStackIn.m_85837_(0.5, 0.5, 0.5);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-f));
            matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE));
            float lidAngle = blockEntity.m_6683_(partialTicks);
            this.renderModels(matrixStackIn, ivertexbuilder, this.lid, this.lock, this.bottom, this.inner, lidAngle, combinedLightIn, combinedOverlayIn);
            if (isInWorld && !(stack = blockEntity.m_8020_(0)).m_41619_()) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_(0.5, 0.4, 0.5);
                Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, 0);
                matrixStackIn.m_85849_();
            }
            matrixStackIn.m_85849_();
        }
    }

    private void renderModels(PoseStack matrixStackIn, VertexConsumer bufferIn, ModelPart chestLid, ModelPart chestLatch, ModelPart chestBottom, ModelPart chestInner, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        chestLatch.f_104203_ = chestLid.f_104203_ = -(lidAngle * 1.5707964f);
        chestLid.m_104301_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestLatch.m_104301_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestBottom.m_104301_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestInner.m_104301_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }
}

