/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.Localization;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.ComponentMenuCamouflageAdvanced;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.RadioButton;
import vswe.superfactory.components.RadioButtonList;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;

public class ComponentMenuCamouflageInside
extends ComponentMenuCamouflageAdvanced {
    private static final String NBT_SETTING = "Setting";
    private static final int RADIO_BUTTON_SPACING = 12;
    private static final int RADIO_BUTTON_X = 5;
    private static final int RADIO_BUTTON_Y = 5;
    private RadioButtonList radioButtons = new RadioButtonList(){

        @Override
        public void updateSelectedOption(int selectedOption) {
            this.setSelectedOption(selectedOption);
            DataWriter dw = ComponentMenuCamouflageInside.this.getWriterForServerComponentPacket();
            dw.writeData(ComponentMenuCamouflageInside.this.radioButtons.getSelectedOption(), DataBitHelper.CAMOUFLAGE_INSIDE);
            PacketHandler.sendDataToServer(dw);
        }
    };

    public ComponentMenuCamouflageInside(FlowComponent parent) {
        super(parent);
        for (int i = 0; i < InsideSetType.values().length; ++i) {
            this.radioButtons.add(new RadioButton(5, 5 + i * 12, InsideSetType.values()[i].name));
        }
    }

    @Override
    public String getName() {
        return Localization.INSIDE_MENU.toString();
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        this.radioButtons.onClick(mX, mY, button);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeData(this.radioButtons.getSelectedOption(), DataBitHelper.CAMOUFLAGE_INSIDE);
    }

    @Override
    public void readData(DataReader dr) {
        this.radioButtons.setSelectedOption(dr.readData(DataBitHelper.CAMOUFLAGE_INSIDE));
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        this.radioButtons.setSelectedOption(((ComponentMenuCamouflageInside)menu).radioButtons.getSelectedOption());
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuCamouflageInside newDataInside = (ComponentMenuCamouflageInside)newData;
        if (this.radioButtons.getSelectedOption() != newDataInside.radioButtons.getSelectedOption()) {
            this.radioButtons.setSelectedOption(newDataInside.radioButtons.getSelectedOption());
            DataWriter dw = this.getWriterForClientComponentPacket(container);
            dw.writeData(this.radioButtons.getSelectedOption(), DataBitHelper.CAMOUFLAGE_INSIDE);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.radioButtons.setSelectedOption(nbtTagCompound.func_74771_c(NBT_SETTING));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74774_a(NBT_SETTING, (byte)this.radioButtons.getSelectedOption());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        this.radioButtons.draw(gui, mX, mY);
    }

    @Override
    protected String getWarningText() {
        return Localization.INSIDE_WARNING.toString();
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        this.radioButtons.setSelectedOption(dr.readData(DataBitHelper.CAMOUFLAGE_INSIDE));
    }

    public InsideSetType getCurrentType() {
        return InsideSetType.values()[this.radioButtons.getSelectedOption()];
    }

    public static enum InsideSetType {
        ONLY_OUTSIDE(Localization.CAMOUFLAGE_ONLY_OUTSIDE),
        ONLY_INSIDE(Localization.CAMOUFLAGE_ONLY_INSIDE),
        OPPOSITE(Localization.CAMOUFLAGE_OPPOSITE_INSIDE),
        SAME(Localization.CAMOUFLAGE_SAME_INSIDE),
        NOTHING(Localization.CAMOUFLAGE_NO_UPDATE);

        private Localization name;

        private InsideSetType(Localization name) {
            this.name = name;
        }
    }
}

