/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.tiles;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import vswe.superfactory.blocks.BlockCableRelay;
import vswe.superfactory.blocks.ClusterMethodRegistration;
import vswe.superfactory.blocks.ITileEntityInterface;
import vswe.superfactory.interfaces.ContainerRelay;
import vswe.superfactory.interfaces.GuiRelay;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;
import vswe.superfactory.tiles.TileEntityClusterElement;
import vswe.superfactory.util.UserPermission;
import vswe.superfactory.wrappers.InventoryWrapper;
import vswe.superfactory.wrappers.InventoryWrapperPlayer;

public class TileEntityRelay
extends TileEntityClusterElement
implements IInventory,
ISidedInventory,
IFluidHandler,
ITileEntityInterface {
    private static final int MAX_CHAIN_LENGTH = 512;
    private static final String NBT_ACTIVE = "Active";
    private static final String NBT_CREATIVE = "Creative";
    private static final String NBT_EDITOR = "Editor";
    private static final String NBT_LIST = "ShowList";
    private static final String NBT_NAME = "Name";
    private static final String NBT_OWNER = "Owner";
    private static final String NBT_PERMISSIONS = "Permissions";
    private static final String NBT_UUID = "UUID";
    public static int PERMISSION_MAX_LENGTH = 255;
    private boolean blockingUsage;
    private int[] cachedAllSlots;
    private Entity[] cachedEntities = new Entity[2];
    private InventoryWrapper cachedInventoryWrapper;
    private int chainLength;
    private boolean creativeMode;
    private boolean doesListRequireOp = false;
    private UUID owner = null;
    private List<UserPermission> permissions = new ArrayList<UserPermission>();

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            this.owner = entity.func_110124_au();
        }
    }

    public void setListRequireOp(boolean val) {
        this.doesListRequireOp = val;
    }

    public List<UserPermission> getPermissions() {
        return this.permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] func_180463_a(EnumFacing side) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                if (inventory instanceof ISidedInventory) {
                    int[] nArray = ((ISidedInventory)inventory).func_180463_a(side);
                    return nArray;
                }
                int size = inventory.func_70302_i_();
                if (this.cachedAllSlots == null || this.cachedAllSlots.length != size) {
                    this.cachedAllSlots = new int[size];
                    for (int i = 0; i < size; ++i) {
                        this.cachedAllSlots[i] = i;
                    }
                }
                int[] nArray = this.cachedAllSlots;
                return nArray;
            }
            int[] nArray = new int[]{};
            return nArray;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing side) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                if (inventory instanceof ISidedInventory) {
                    boolean bl = ((ISidedInventory)inventory).func_180462_a(i, itemstack, side);
                    return bl;
                }
                boolean bl = inventory.func_94041_b(i, itemstack);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing side) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                if (inventory instanceof ISidedInventory) {
                    boolean bl = ((ISidedInventory)inventory).func_180461_b(i, itemstack, side);
                    return bl;
                }
                boolean bl = inventory.func_94041_b(i, itemstack);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unBlockUsage();
        }
    }

    private void unBlockUsage() {
        this.blockingUsage = false;
        this.chainLength = 0;
    }

    private IInventory getInventory() {
        return this.getContainer(IInventory.class, 0);
    }

    private <T> T getContainer(Class<T> type, int id) {
        IBlockState state;
        if (this.isBlockingUsage()) {
            return null;
        }
        this.blockUsage();
        if (this.cachedEntities[id] != null) {
            if (this.cachedEntities[id].field_70128_L) {
                this.cachedEntities[id] = null;
                if (id == 0) {
                    this.cachedInventoryWrapper = null;
                }
            } else {
                return this.getEntityContainer(id);
            }
        }
        if ((state = this.func_145831_w().func_180495_p(this.field_174879_c)).func_177230_c() == Blocks.field_150350_a) {
            return null;
        }
        EnumFacing direction = (EnumFacing)state.func_177229_b(BlockCableRelay.FACING);
        int x = this.func_174877_v().func_177958_n() + direction.func_82601_c();
        int y = this.func_174877_v().func_177956_o() + direction.func_96559_d();
        int z = this.func_174877_v().func_177952_p() + direction.func_82599_e();
        World world = this.func_145831_w();
        if (world != null) {
            TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
            if (type.isInstance(te)) {
                if (te instanceof TileEntityRelay) {
                    TileEntityRelay relay = (TileEntityRelay)te;
                    relay.chainLength = this.chainLength + 1;
                }
                return (T)te;
            }
            List entities = world.func_72872_a(Entity.class, new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
            if (entities != null) {
                double closest = -1.0;
                for (Entity entity : entities) {
                    double distance = entity.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
                    if (!this.isEntityValid(entity, type, id) || closest != -1.0 && !(distance < closest)) continue;
                    closest = distance;
                    this.cachedEntities[id] = entity;
                }
                if (id == 0 && this.cachedEntities[id] != null) {
                    this.cachedInventoryWrapper = this.getInventoryWrapper(this.cachedEntities[id]);
                }
                return this.getEntityContainer(id);
            }
        }
        return null;
    }

    private void blockUsage() {
        this.blockingUsage = true;
    }

    public boolean isBlockingUsage() {
        return this.blockingUsage || this.chainLength >= 512;
    }

    private InventoryWrapper getInventoryWrapper(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return new InventoryWrapperPlayer((EntityPlayer)entity);
        }
        return null;
    }

    private boolean isEntityValid(Entity entity, Class type, int id) {
        return type.isInstance(entity) || id == 0 && (entity instanceof EntityPlayer && this.allowPlayerInteraction((EntityPlayer)entity) || entity instanceof EntityHorse);
    }

    public boolean allowPlayerInteraction(EntityPlayer player) {
        return this.isAdvanced() && this.creativeMode != this.isPlayerActive(player);
    }

    private boolean isAdvanced() {
        return BlockCableRelay.isAdvanced(this.func_145832_p());
    }

    private boolean isPlayerActive(EntityPlayer player) {
        if (player != null) {
            for (UserPermission permission : this.permissions) {
                if (!permission.getUserId().equals(player.func_110124_au())) continue;
                return permission.isActive();
            }
        }
        return false;
    }

    private <T> T getEntityContainer(int id) {
        if (id == 0 && this.cachedInventoryWrapper != null) {
            return (T)this.cachedInventoryWrapper;
        }
        return (T)this.cachedEntities[id];
    }

    public int func_70302_i_() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                int n = inventory.func_70302_i_();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.unBlockUsage();
        }
    }

    public boolean func_191420_l() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70301_a(int i) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                ItemStack itemStack = inventory.func_70301_a(i);
                return itemStack;
            }
            ItemStack itemStack = ItemStack.field_190927_a;
            return itemStack;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70298_a(int i, int j) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                ItemStack itemStack = inventory.func_70298_a(i, j);
                return itemStack;
            }
            ItemStack itemStack = ItemStack.field_190927_a;
            return itemStack;
        }
        finally {
            this.unBlockUsage();
        }
    }

    public ItemStack func_70304_b(int i) {
        return ItemStack.field_190927_a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70299_a(int i, ItemStack itemstack) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                inventory.func_70299_a(i, itemstack);
            }
        }
        finally {
            this.unBlockUsage();
        }
    }

    public int func_70297_j_() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                int n = inventory.func_70297_j_();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_70300_a(EntityPlayer entityplayer) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                boolean bl = inventory.func_70300_a(entityplayer);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unBlockUsage();
        }
    }

    public void func_174889_b(EntityPlayer player) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                inventory.func_174889_b(player);
            }
        }
        finally {
            this.unBlockUsage();
        }
    }

    public void func_174886_c(EntityPlayer player) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                inventory.func_174886_c(player);
            }
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_94041_b(int i, ItemStack itemstack) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                boolean bl = inventory.func_94041_b(i, itemstack);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int func_174887_a_(int id) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                int n = inventory.func_174890_g();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_174885_b(int id, int value) {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                inventory.func_174885_b(id, value);
            }
        }
        finally {
            this.unBlockUsage();
        }
    }

    public int func_174890_g() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                int n = inventory.func_174890_g();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.unBlockUsage();
        }
    }

    public void func_174888_l() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                inventory.func_174888_l();
            }
        }
        finally {
            this.unBlockUsage();
        }
    }

    public String func_70005_c_() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                String string = inventory.func_70005_c_();
                return string;
            }
            String string = "Unknown";
            return string;
        }
        finally {
            this.unBlockUsage();
        }
    }

    public boolean func_145818_k_() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                boolean bl = inventory.func_145818_k_();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unBlockUsage();
        }
    }

    public void func_70296_d() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                inventory.func_70296_d();
            }
        }
        finally {
            this.unBlockUsage();
        }
    }

    public ITextComponent func_145748_c_() {
        try {
            IInventory inventory = this.getInventory();
            if (inventory != null) {
                ITextComponent iTextComponent = inventory.func_145748_c_();
                return iTextComponent;
            }
            ITextComponent iTextComponent = null;
            return iTextComponent;
        }
        finally {
            this.unBlockUsage();
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new InvWrapper((IInventory)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void func_73660_a() {
        this.cachedEntities[0] = null;
        this.cachedEntities[1] = null;
        this.cachedInventoryWrapper = null;
    }

    @Override
    public void readContentFromNBT(NBTTagCompound nbtTagCompound) {
        byte version = nbtTagCompound.func_74771_c("ProtocolVersion");
        if (nbtTagCompound.func_74764_b(NBT_OWNER)) {
            this.owner = version > 12 ? UUID.fromString(nbtTagCompound.func_74779_i(NBT_OWNER)) : null;
            this.creativeMode = nbtTagCompound.func_74767_n(NBT_CREATIVE);
            this.doesListRequireOp = nbtTagCompound.func_74767_n(NBT_LIST);
            this.permissions.clear();
            NBTTagList permissionTags = nbtTagCompound.func_150295_c(NBT_PERMISSIONS, 10);
            for (int i = 0; i < permissionTags.func_74745_c(); ++i) {
                NBTTagCompound permissionTag = permissionTags.func_150305_b(i);
                UserPermission permission = new UserPermission(UUID.fromString(permissionTag.func_74779_i(NBT_UUID)), permissionTag.func_74779_i(NBT_NAME));
                permission.setActive(permissionTag.func_74767_n(NBT_ACTIVE));
                permission.setOp(permissionTag.func_74767_n(NBT_EDITOR));
                this.permissions.add(permission);
            }
        }
    }

    @Override
    public void writeContentToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74774_a("ProtocolVersion", (byte)14);
        if (this.isAdvanced()) {
            nbtTagCompound.func_74778_a(NBT_OWNER, this.owner != null ? this.owner.toString() : UUID.randomUUID().toString());
            nbtTagCompound.func_74757_a(NBT_CREATIVE, this.creativeMode);
            nbtTagCompound.func_74757_a(NBT_LIST, this.doesListRequireOp);
            NBTTagList permissionTags = new NBTTagList();
            for (UserPermission permission : this.permissions) {
                NBTTagCompound permissionTag = new NBTTagCompound();
                permissionTag.func_74778_a(NBT_UUID, permission.getUserId().toString());
                permissionTag.func_74778_a(NBT_NAME, permission.getUserName());
                permissionTag.func_74757_a(NBT_ACTIVE, permission.isActive());
                permissionTag.func_74757_a(NBT_EDITOR, permission.isOp());
                permissionTags.func_74742_a((NBTBase)permissionTag);
            }
            nbtTagCompound.func_74782_a(NBT_PERMISSIONS, (NBTBase)permissionTags);
        }
    }

    @Override
    protected EnumSet<ClusterMethodRegistration> getRegistrations() {
        return EnumSet.of(ClusterMethodRegistration.ON_BLOCK_PLACED_BY, ClusterMethodRegistration.ON_BLOCK_ACTIVATED);
    }

    @Override
    public Container getContainer(TileEntity te, InventoryPlayer inv) {
        return new ContainerRelay((TileEntityRelay)te, inv);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(TileEntity te, InventoryPlayer inv) {
        return new GuiRelay((TileEntityRelay)te, inv);
    }

    @Override
    public void readAllData(DataReader dr, EntityPlayer player) {
        this.owner = UUID.fromString(dr.readString(DataBitHelper.UUID_LENGTH));
        this.creativeMode = dr.readBoolean();
        this.doesListRequireOp = dr.readBoolean();
        int length = dr.readData(DataBitHelper.PERMISSION_ID);
        this.permissions.clear();
        for (int i = 0; i < length; ++i) {
            UserPermission permission = new UserPermission(UUID.fromString(dr.readString(DataBitHelper.UUID_LENGTH)), dr.readString(DataBitHelper.NAME_LENGTH));
            permission.setActive(dr.readBoolean());
            permission.setOp(dr.readBoolean());
            this.permissions.add(permission);
        }
    }

    @Override
    public void readUpdatedData(DataReader dr, EntityPlayer player) {
        boolean action;
        if (!this.field_145850_b.field_72995_K && (action = dr.readBoolean())) {
            return;
        }
        UUID userId = player.func_110124_au();
        boolean isOp = false;
        if (this.field_145850_b.field_72995_K || userId.equals(this.owner)) {
            isOp = true;
        } else {
            for (UserPermission permission : this.permissions) {
                if (!userId.equals(permission.getUserId())) continue;
                isOp = permission.isOp();
                break;
            }
        }
        boolean userData = dr.readBoolean();
        if (userData) {
            boolean added = dr.readBoolean();
            if (added) {
                String UUIDS = dr.readString(DataBitHelper.UUID_LENGTH);
                UserPermission permission = new UserPermission(UUID.fromString(UUIDS), dr.readString(DataBitHelper.NAME_LENGTH));
                for (UserPermission userPermission : this.permissions) {
                    if (!userPermission.getUserId().equals(permission.getUserId())) continue;
                    return;
                }
                if (this.field_145850_b.field_72995_K) {
                    permission.setActive(dr.readBoolean());
                    permission.setOp(dr.readBoolean());
                }
                if (this.permissions.size() < PERMISSION_MAX_LENGTH && (this.field_145850_b.field_72995_K || permission.getUserId().equals(userId))) {
                    this.permissions.add(permission);
                }
            } else {
                int id = dr.readData(DataBitHelper.PERMISSION_ID);
                if (id >= 0 && id < this.permissions.size()) {
                    boolean deleted = dr.readBoolean();
                    if (deleted) {
                        UserPermission permission = this.permissions.get(id);
                        if (isOp || permission.getUserId().equals(userId)) {
                            this.permissions.remove(id);
                        }
                    } else if (isOp) {
                        UserPermission permission = this.permissions.get(id);
                        permission.setActive(dr.readBoolean());
                        permission.setOp(dr.readBoolean());
                    }
                }
            }
        } else if (isOp) {
            this.creativeMode = dr.readBoolean();
            this.doesListRequireOp = dr.readBoolean();
        }
    }

    @Override
    public void writeAllData(DataWriter dw) {
        dw.writeString(this.owner.toString(), DataBitHelper.UUID_LENGTH);
        dw.writeBoolean(this.creativeMode);
        dw.writeBoolean(this.doesListRequireOp);
        dw.writeData(this.permissions.size(), DataBitHelper.PERMISSION_ID);
        for (UserPermission permission : this.permissions) {
            dw.writeString(permission.getUserId().toString(), DataBitHelper.UUID_LENGTH);
            dw.writeString(permission.getUserName(), DataBitHelper.NAME_LENGTH);
            dw.writeBoolean(permission.isActive());
            dw.writeBoolean(permission.isOp());
        }
    }

    public void updateData(ContainerRelay container) {
        if (container.oldCreativeMode != this.isCreativeMode() || container.oldOpList != this.doesListRequireOp()) {
            container.oldOpList = this.doesListRequireOp();
            container.oldCreativeMode = this.isCreativeMode();
            DataWriter dw = PacketHandler.getWriterForUpdate(container);
            dw.writeBoolean(false);
            dw.writeBoolean(this.creativeMode);
            dw.writeBoolean(this.doesListRequireOp);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
        if (this.permissions.size() > container.oldPermissions.size()) {
            int id = container.oldPermissions.size();
            UserPermission permission = this.permissions.get(id);
            DataWriter dw = PacketHandler.getWriterForUpdate(container);
            dw.writeBoolean(true);
            dw.writeBoolean(true);
            dw.writeString(permission.getUserId().toString(), DataBitHelper.UUID_LENGTH);
            dw.writeString(permission.getUserName(), DataBitHelper.NAME_LENGTH);
            dw.writeBoolean(permission.isActive());
            dw.writeBoolean(permission.isOp());
            PacketHandler.sendDataToListeningClients(container, dw);
            container.oldPermissions.add(permission.copy());
        } else if (this.permissions.size() < container.oldPermissions.size()) {
            for (int i = 0; i < container.oldPermissions.size(); ++i) {
                if (i < this.permissions.size() && this.permissions.get(i).getUserId().equals(container.oldPermissions.get(i).getUserId())) continue;
                DataWriter dw = PacketHandler.getWriterForUpdate(container);
                dw.writeBoolean(true);
                dw.writeBoolean(false);
                dw.writeData(i, DataBitHelper.PERMISSION_ID);
                dw.writeBoolean(true);
                PacketHandler.sendDataToListeningClients(container, dw);
                container.oldPermissions.remove(i);
                break;
            }
        } else {
            for (int i = 0; i < this.permissions.size(); ++i) {
                UserPermission permission = this.permissions.get(i);
                UserPermission oldPermission = container.oldPermissions.get(i);
                if (permission.isOp() == oldPermission.isOp() && permission.isActive() == oldPermission.isActive()) continue;
                DataWriter dw = PacketHandler.getWriterForUpdate(container);
                dw.writeBoolean(true);
                dw.writeBoolean(false);
                dw.writeData(i, DataBitHelper.PERMISSION_ID);
                dw.writeBoolean(false);
                dw.writeBoolean(permission.isActive());
                dw.writeBoolean(permission.isOp());
                PacketHandler.sendDataToListeningClients(container, dw);
                oldPermission.setActive(permission.isActive());
                oldPermission.setOp(permission.isOp());
            }
        }
    }

    public boolean doesListRequireOp() {
        return this.doesListRequireOp;
    }

    public boolean isCreativeMode() {
        return this.creativeMode;
    }

    public void setCreativeMode(boolean creativeMode) {
        this.creativeMode = creativeMode;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(FluidStack resource, boolean doFill) {
        try {
            IFluidHandler tank = this.getTank();
            if (tank != null) {
                int n = tank.fill(resource, doFill);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.unBlockUsage();
        }
    }

    private IFluidHandler getTank() {
        return this.getContainer(IFluidHandler.class, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        try {
            IFluidHandler tank = this.getTank();
            if (tank != null) {
                FluidStack fluidStack = tank.drain(resource, doDrain);
                return fluidStack;
            }
            FluidStack fluidStack = null;
            return fluidStack;
        }
        finally {
            this.unBlockUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        try {
            IFluidHandler tank = this.getTank();
            if (tank != null) {
                FluidStack fluidStack = tank.drain(maxDrain, doDrain);
                return fluidStack;
            }
            FluidStack fluidStack = null;
            return fluidStack;
        }
        finally {
            this.unBlockUsage();
        }
    }
}

