/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class Utils {
    private static final Pattern patternControlCode = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");

    public static String stripControlCodes(String s) {
        return patternControlCode.matcher(s).replaceAll("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBTTagCompound readCompressed(byte[] bytes, NBTSizeTracker sizeTracker) throws IOException {
        NBTTagCompound nbttagcompound;
        try (DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(bytes))));){
            nbttagcompound = CompressedStreamTools.func_152456_a((DataInput)datainputstream, (NBTSizeTracker)sizeTracker);
        }
        return nbttagcompound;
    }

    public static byte[] compress(NBTTagCompound tagCompound) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        try (DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(bytearrayoutputstream));){
            CompressedStreamTools.func_74800_a((NBTTagCompound)tagCompound, (DataOutput)dataoutputstream);
        }
        return bytearrayoutputstream.toByteArray();
    }
}

