/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.SearchUtil;
import ca.teamdman.sfm.common.util.SFMUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;

public class ItemStackSearchIndexer
implements Callable<Multimap<ItemStack, String>> {
    private final ExecutorService pool = Executors.newFixedThreadPool(1);

    private static void populateStressTest(List<ItemStack> list) {
        ListIterator<ItemStack> iter = list.listIterator();
        while (list.size() < 100000) {
            list.add((ItemStack)iter.next());
        }
    }

    public CompletableFuture<Multimap<ItemStack, String>> buildCache() {
        return CompletableFuture.supplyAsync(this::call);
    }

    @Override
    public Multimap<ItemStack, String> call() {
        long start = System.currentTimeMillis();
        ArrayListMultimap rtn = ArrayListMultimap.create();
        ItemStackSearchIndexer.getSearchableItems().filter(Objects::nonNull).filter(itemStack -> !itemStack.func_190926_b()).forEach(arg_0 -> ItemStackSearchIndexer.lambda$call$2((Multimap)rtn, arg_0));
        SFM.LOGGER.info(SFMUtil.getMarker(SearchUtil.class), "Indexed {} items in {} ms", (Object)rtn.keys().size(), (Object)(System.currentTimeMillis() - start));
        return rtn;
    }

    public static Stream<ItemStack> getSearchableItems() {
        return Registry.field_212630_s.func_201756_e().filter(Objects::nonNull).filter(i -> i.getCreativeTabs().size() > 0).map(ItemStackSearchIndexer::getSubItems).flatMap(Collection::stream);
    }

    private static List<ItemStack> getSubItems(Item item) {
        NonNullList rtn = NonNullList.func_191196_a();
        try {
            item.func_150895_a(ItemGroup.field_78027_g, rtn);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtn;
    }

    private static /* synthetic */ void lambda$call$2(Multimap rtn, ItemStack stack) {
        try {
            rtn.put((Object)stack, (Object)stack.func_200301_q().getString());
            rtn.put((Object)stack, (Object)stack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.ADVANCED).stream().map(ITextComponent::getString).collect(Collectors.joining(" ")));
            stack.func_77973_b().getTags().forEach(tag -> rtn.put((Object)stack, (Object)tag.toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

