/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client;

import ca.teamdman.sfm.client.ItemStackSearchIndexer;
import ca.teamdman.sfm.common.config.Config;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;

public class SearchUtil {
    private static final CompletableFuture<Multimap<ItemStack, String>> cache = new ItemStackSearchIndexer().buildCache();
    public static final Comparator<ItemStack> SEARCH_RESULT_COMPARATOR = Comparator.comparingInt(SearchUtil::sortMinecraftFirst).thenComparingInt(SearchUtil::sortShorterNamesFirst).thenComparing(x -> x.func_200301_q().getString());

    public static SearchResults search(String query) {
        Pattern pattern = SearchUtil.getPattern(query);
        ConcurrentLinkedQueue<ItemStack> results = new ConcurrentLinkedQueue<ItemStack>();
        AtomicBoolean finished = new AtomicBoolean(false);
        Thread t = new Thread(() -> {
            try {
                for (Map.Entry entry : cache.get().asMap().entrySet()) {
                    if (!((Collection)entry.getValue()).stream().anyMatch(v -> pattern.matcher((CharSequence)v).find())) continue;
                    results.add((ItemStack)entry.getKey());
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            finally {
                finished.set(true);
            }
        });
        t.start();
        return new SearchResults(t, results, finished);
    }

    private static Pattern getPattern(String search) {
        Pattern basicPattern = Pattern.compile(Pattern.quote(search), 2);
        if (!Config.Client.enableRegexSearch) {
            return basicPattern;
        }
        try {
            return Pattern.compile(search, 2);
        }
        catch (PatternSyntaxException e) {
            return basicPattern;
        }
    }

    private static int sortMinecraftFirst(ItemStack in) {
        return in.func_77973_b().getRegistryName() != null && in.func_77973_b().getRegistryName().func_110624_b().equals("minecraft") ? 0 : 1;
    }

    private static int sortShorterNamesFirst(ItemStack in) {
        return in.func_200301_q().getString().length();
    }

    public static class SearchResults {
        private final Queue<ItemStack> result;
        private final Thread background;
        private final AtomicBoolean finished;
        private int processed = 0;

        public SearchResults(Thread background, Queue<ItemStack> result, AtomicBoolean finished) {
            this.background = background;
            this.result = result;
            this.finished = finished;
        }

        public Queue<ItemStack> get() {
            return this.result;
        }

        public void cancel() {
            this.background.stop();
        }

        public Stream<ItemStack> streamLatestResults() {
            if (this.processed == this.result.size()) {
                return Stream.empty();
            }
            return IntStream.range(this.processed, this.result.size()).mapToObj(i -> this.result.poll());
        }

        public boolean isFinished() {
            return this.finished.get();
        }
    }
}

