/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.core;

import ca.teamdman.sfm.client.gui.flow.core.Colour3f;
import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.core.ScissorInfo;
import ca.teamdman.sfm.common.flow.core.Position;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.opengl.GL11;

public abstract class BaseScreen
extends Screen {
    public static final Colour3f DEFAULT_LINE_COLOUR = new Colour3f(0.4f, 0.4f, 0.4f);
    public static final Colour3f HIGHLIGHTED_LINE_COLOUR = new Colour3f(0.15686275f, 0.5294118f, 0.94509804f);
    final int zLevel = 0;
    private final Deque<ScissorInfo> SCISSOR_STACK = new ArrayDeque<ScissorInfo>();
    protected int guiLeft;
    protected int guiTop;
    protected int scaledWidth;
    protected int scaledHeight;
    private int latestMouseX;
    private int latestMouseY;

    public BaseScreen(ITextComponent titleIn, int scaledWidth, int scaledHeight) {
        super(titleIn);
        this.scaledWidth = scaledWidth;
        this.scaledHeight = scaledHeight;
    }

    public static void bindTexture(ResourceLocation resource) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getScaledWidth() {
        return this.scaledWidth;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public int getScaledHeight() {
        return this.scaledHeight;
    }

    public ItemRenderer getItemRenderer() {
        return this.field_230707_j_;
    }

    public void drawCenteredString(MatrixStack matrixStack, String str, int x, int y, Colour3f colour) {
        this.drawCenteredString(matrixStack, str, x, y, 1.0f, colour);
    }

    public void drawCenteredString(MatrixStack matrixStack, String str, int x, int y, float scale, Colour3f colour) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        this.getFontRenderer().func_238421_b_(matrixStack, str, (float)((int)((float)x / scale) - this.getFontRenderer().func_78256_a(str) / 2), (float)((int)((float)y / scale)), colour.toInt());
        matrixStack.func_227865_b_();
    }

    public FontRenderer getFontRenderer() {
        return this.field_230712_o_ != null ? this.field_230712_o_ : Minecraft.func_71410_x().field_71466_p;
    }

    public void drawCenteredString(MatrixStack matrixStack, String str, FlowComponent component, float scale, Colour3f colour) {
        this.drawCenteredString(matrixStack, str, component.getPosition().getX() + component.getSize().getWidth() / 2, component.getPosition().getY() + (component.getSize().getHeight() - (int)(8.0f * scale)) / 2, scale, colour);
    }

    public void drawRightAlignedString(MatrixStack matrixStack, String str, int x, int y, Colour3f colour) {
        this.drawString(matrixStack, str, (int)((double)x - this.fixScaledCoordinate(this.field_230712_o_.func_78256_a(str), this.getScale(), Minecraft.func_71410_x().func_228018_at_().func_198105_m())), y, colour);
    }

    public void drawString(MatrixStack matrixStack, String str, int x, int y, Colour3f colour) {
        this.drawString(matrixStack, str, x, y, 1.0f, colour);
    }

    public double fixScaledCoordinate(int val, double scale, int size) {
        double d = (double)val / scale;
        d *= (double)size;
        d = Math.floor(d);
        d /= (double)size;
        return d *= scale;
    }

    public double getScale() {
        double xFactor = (float)this.field_230708_k_ * 0.9f / (float)this.scaledWidth;
        double yFactor = (float)this.field_230709_l_ * 0.9f / (float)this.scaledHeight;
        double mult = Math.min(xFactor, yFactor);
        mult = Math.min(1.0, mult);
        mult = Math.floor(mult * 1000.0) / 1000.0;
        return mult;
    }

    public void drawString(MatrixStack matrixStack, String str, int x, int y, float scale, Colour3f colour) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        this.getFontRenderer().func_238421_b_(matrixStack, str, (float)((int)((float)x / scale)), (float)((int)((float)y / scale)), colour.toInt());
        matrixStack.func_227865_b_();
    }

    public boolean func_231044_a_(double x, double y, int button) {
        int mx = this.scaleX(x);
        int my = this.scaleY(y);
        return this.mouseClickedScaled(mx, my, button);
    }

    public boolean func_231048_c_(double x, double y, int button) {
        int mx = this.scaleX(x);
        int my = this.scaleY(y);
        return this.mouseReleasedScaled(mx, my, button);
    }

    public boolean mouseReleasedScaled(int mx, int my, int button) {
        return false;
    }

    public boolean func_231045_a_(double x, double y, int button, double dx, double dy) {
        int mx = this.scaleX(x);
        int my = this.scaleY(y);
        int dmx = this.scaleX(dx);
        int dmy = this.scaleY(dy);
        return this.onMouseDraggedScaled(mx, my, button, dmx, dmy);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        return this.mouseScrolledScaled(this.scaleX(mouseX), this.scaleY(mouseY), scroll);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        return super.func_223281_a_(keyCode, scanCode, modifiers) || this.keyReleasedScaled(keyCode, scanCode, modifiers, this.getLatestMouseX(), this.getLatestMouseY());
    }

    public boolean keyReleasedScaled(int keyCode, int scanCode, int modifiers, int mx, int my) {
        return false;
    }

    public int getLatestMouseX() {
        return this.latestMouseX;
    }

    public int getLatestMouseY() {
        return this.latestMouseY;
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        return this.charTypedScaled(codePoint, modifiers, this.scaleX(this.getLatestMouseX()), this.scaleY(this.getLatestMouseY()));
    }

    public boolean charTypedScaled(char codePoint, int modifiers, int mx, int my) {
        return false;
    }

    public boolean mouseScrolledScaled(int mx, int my, double scroll) {
        return false;
    }

    public boolean onMouseDraggedScaled(int mx, int my, int button, int dmx, int dmy) {
        return false;
    }

    public int scaleX(double x) {
        double scale = this.getScale();
        x /= scale;
        return (int)(x -= ((double)this.field_230708_k_ - (double)this.scaledWidth * scale) / (2.0 * scale));
    }

    public int scaleY(double y) {
        double scale = this.getScale();
        y /= scale;
        return (int)(y -= ((double)this.field_230709_l_ - (double)this.scaledHeight * scale) / (2.0 * scale));
    }

    public boolean mouseClickedScaled(int mx, int my, int button) {
        return false;
    }

    public void func_212927_b(double xPos, double mouseY) {
        int mx = this.scaleX(xPos);
        int my = this.scaleY(mouseY);
        this.mouseMovedScaled(mx, my);
    }

    public boolean mouseMovedScaled(int mx, int my) {
        return false;
    }

    public void drawTexture(MatrixStack matrixStack, int x, int y, int srcX, int srcY, int w, int h) {
        this.func_238474_b_(matrixStack, x, y, srcX, srcY, w, h);
    }

    public void drawTextureWithRGBA(MatrixStack matrixStack, int x, int y, int srcX, int srcY, int w, int h, float r, float g, float b, float a) {
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        int blitOffset = this.func_230927_p_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)(y + h), (float)blitOffset).func_227885_a_(r, g, b, a).func_225583_a_(((float)srcX + 0.0f) / 256.0f, ((float)srcY + (float)h) / 256.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)(x + w), (float)(y + h), (float)blitOffset).func_227885_a_(r, g, b, a).func_225583_a_(((float)srcX + (float)w) / 256.0f, ((float)srcY + (float)h) / 256.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)(x + w), (float)y, (float)blitOffset).func_227885_a_(r, g, b, a).func_225583_a_(((float)srcX + (float)w) / 256.0f, ((float)srcY + 0.0f) / 256.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)y, (float)blitOffset).func_227885_a_(r, g, b, a).func_225583_a_(((float)srcX + 0.0f) / 256.0f, ((float)srcY + 0.0f) / 256.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.startScaling(matrixStack);
        int mx = this.scaleX(mouseX);
        int my = this.scaleY(mouseY);
        this.latestMouseX = mx;
        this.latestMouseY = my;
        this.drawScaled(matrixStack, mx, my, partialTicks);
        this.stopScaling(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return super.func_231046_a_(keyCode, scanCode, modifiers) || this.keyPressedScaled(keyCode, scanCode, modifiers, this.getLatestMouseX(), this.getLatestMouseY());
    }

    public boolean keyPressedScaled(int keyCode, int scanCode, int modifiers, int mx, int my) {
        return false;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - this.scaledWidth) / 2;
        this.guiTop = (this.field_230709_l_ - this.scaledHeight) / 2;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void startScaling(MatrixStack matrixStack) {
        float scale = (float)this.getScale();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((float)this.field_230708_k_ / 2.0f), (double)((float)this.field_230709_l_ / 2.0f), 0.0);
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        matrixStack.func_227861_a_((double)((float)(-this.scaledWidth) / 2.0f), (double)((float)(-this.scaledHeight) / 2.0f), 0.0);
    }

    public void drawScaled(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    public void stopScaling(MatrixStack matrixStack) {
        matrixStack.func_227865_b_();
    }

    public void drawBorder(MatrixStack matrixStack, int x, int y, int width, int height, int thickness, Colour3f colour) {
        this.drawRect(matrixStack, x, y, width, thickness, colour);
        this.drawRect(matrixStack, x, y + height - thickness, width, thickness, colour);
        this.drawRect(matrixStack, x, y, thickness, height, colour);
        this.drawRect(matrixStack, x + width - thickness, y, thickness, height, colour);
    }

    public void drawRect(MatrixStack matrixStack, int x, int y, int width, int height, Colour3f colour) {
        this.drawQuad(matrixStack, x, y, x, y + height, x + width, y + height, x + width, y, colour);
    }

    public void drawQuad(MatrixStack matrixStack, int ax, int ay, int bx, int by, int cx, int cy, int dx, int dy, Colour3f colour) {
        Matrix4f m = matrixStack.func_227866_c_().func_227870_a_();
        matrixStack.func_227860_a_();
        RenderSystem.disableTexture();
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_227888_a_(m, (float)ax, (float)ay, 0.0f).func_227885_a_(colour.RED, colour.GREEN, colour.BLUE, 1.0f).func_181675_d();
        bufferBuilder.func_227888_a_(m, (float)bx, (float)by, 0.0f).func_227885_a_(colour.RED, colour.GREEN, colour.BLUE, 1.0f).func_181675_d();
        bufferBuilder.func_227888_a_(m, (float)cx, (float)cy, 0.0f).func_227885_a_(colour.RED, colour.GREEN, colour.BLUE, 1.0f).func_181675_d();
        bufferBuilder.func_227888_a_(m, (float)dx, (float)dy, 0.0f).func_227885_a_(colour.RED, colour.GREEN, colour.BLUE, 1.0f).func_181675_d();
        bufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
        RenderSystem.enableTexture();
        matrixStack.func_227865_b_();
    }

    public double unscaleX(double x) {
        double scale = this.getScale();
        x += ((double)this.field_230708_k_ - (double)this.scaledWidth * scale) / (2.0 * scale);
        return x *= scale;
    }

    public double unscaleY(double y) {
        double scale = this.getScale();
        y += ((double)this.field_230709_l_ - (double)this.scaledHeight * scale) / (2.0 * scale);
        return y *= scale;
    }

    public void drawItemStack(MatrixStack matrixStack, ItemStack stack, int x, int y) {
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        Minecraft.func_71410_x().func_175599_af().field_77023_b = -100.0f;
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, x, y);
        Minecraft.func_71410_x().func_175599_af().field_77023_b = 0.0f;
        RenderSystem.popMatrix();
    }

    public void clearRect(MatrixStack matrixStack, int x, int y, int width, int height) {
        this.beginScissor(matrixStack, x, y, width, height);
        GL11.glClear((int)16640);
        this.endScissor();
    }

    public void beginScissor(MatrixStack matrixStack, int left, int top, int width, int height) {
        GL11.glEnable((int)3089);
        Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_().func_226601_d_();
        Vector4f start = new Vector4f((float)left, (float)top, 1.0f, 1.0f);
        start.func_229372_a_(mat);
        Vector4f end = new Vector4f((float)(left + width), (float)(top + height), 1.0f, 1.0f);
        end.func_229372_a_(mat);
        double mcScaledLeft = start.func_195910_a();
        double mcScaledTop = start.func_195913_b();
        double mcScaledWidth = end.func_195910_a() - start.func_195910_a();
        double mcScaledHeight = end.func_195913_b() - start.func_195913_b();
        double mcScale = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        int mcHeight = Minecraft.func_71410_x().func_228018_at_().func_198091_l();
        int scissorLeft = (int)Math.round(mcScaledLeft * mcScale);
        int scissorBottom = (int)Math.round((double)mcHeight - (mcScaledTop + mcScaledHeight) * mcScale);
        int scissorWidth = (int)Math.floor(mcScaledWidth * mcScale);
        int scissorHeight = (int)Math.floor(mcScaledHeight * mcScale);
        GL11.glScissor((int)scissorLeft, (int)scissorBottom, (int)scissorWidth, (int)scissorHeight);
        this.SCISSOR_STACK.push(new ScissorInfo(scissorLeft, scissorBottom, scissorWidth, scissorHeight));
    }

    public void endScissor() {
        this.SCISSOR_STACK.pop();
        if (this.SCISSOR_STACK.isEmpty()) {
            GL11.glDisable((int)3089);
        } else {
            this.resumeScissor();
        }
    }

    public void pauseScissor() {
        GL11.glDisable((int)3089);
    }

    public void resumeScissor() {
        ScissorInfo info = this.SCISSOR_STACK.peek();
        if (info != null) {
            GL11.glEnable((int)3089);
            GL11.glScissor((int)info.X, (int)info.Y, (int)info.WIDTH, (int)info.HEIGHT);
        }
    }

    public void startScaling() {
        float scale = (float)this.getScale();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)this.field_230708_k_ / 2.0f), (float)((float)this.field_230709_l_ / 2.0f), (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        RenderSystem.translatef((float)((float)(-this.scaledWidth) / 2.0f), (float)((float)(-this.scaledHeight) / 2.0f), (float)0.0f);
    }

    public void stopScaling() {
        RenderSystem.popMatrix();
    }

    public void drawLine(MatrixStack matrixStack, Position from, Position to, Colour3f colour) {
        this.drawLine(matrixStack, from.getX(), from.getY(), to.getX(), to.getY(), colour);
    }

    public void drawLine(MatrixStack matrixStack, int x1, int y1, int x2, int y2, Colour3f colour) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int sqrMag = dx * dx + dy * dy;
        double mag = Math.sqrt(sqrMag == 0 ? 1.0 : (double)sqrMag);
        int width = 4;
        if (x1 == x2 || y1 == y2) {
            width -= 2;
        }
        dx = (int)((double)dx / mag * (double)width / 2.0);
        dy = (int)((double)dy / mag * (double)width / 2.0);
        this.drawQuad(matrixStack, x1 - dy, y1 + dx, x2 - dy, y2 + dx, x2 + dy, y2 - dx, x1 + dy, y1 - dx, colour);
    }

    public void drawArrow(MatrixStack matrixStack, Position from, Position to, Colour3f colour) {
        this.drawArrow(matrixStack, from.getX(), from.getY(), to.getX(), to.getY(), colour);
    }

    public void drawArrow(MatrixStack matrixStack, int x1, int y1, int x2, int y2, Colour3f color) {
        this.drawLine(matrixStack, x1, y1, x2, y2, color);
        int lookX = x2 - x1;
        int lookY = y2 - y1;
        double mag = Math.sqrt(lookX * lookX + lookY * lookY);
        lookX = (int)((double)lookX / (mag *= 0.0625));
        lookY = (int)((double)lookY / mag);
        double ang = -2.748893571891069;
        this.drawLine(matrixStack, x2, y2, x2 + (int)(Math.cos(ang) * (double)lookX - Math.sin(ang) * (double)lookY), y2 + (int)(Math.sin(ang) * (double)lookX + Math.cos(ang) * (double)lookY), color);
        ang = 2.748893571891069;
        this.drawLine(matrixStack, x2, y2, x2 + (int)(Math.cos(ang) * (double)lookX - Math.sin(ang) * (double)lookY), y2 + (int)(Math.sin(ang) * (double)lookX + Math.cos(ang) * (double)lookY), color);
    }
}

