/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.core;

import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.Size;
import ca.teamdman.sfm.common.config.Config;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.core.SizeHolder;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class FlowComponent
implements SizeHolder {
    private final Position dragStart = new Position();
    private final Position dragOffset = new Position();
    private boolean visible = true;
    private boolean enabled = true;
    private boolean draggable = false;
    private boolean dragging = false;
    private boolean hovering = false;
    private Position position;
    private Size size;

    public FlowComponent() {
        this(new Position(), new Size(0, 0));
    }

    public FlowComponent(Position pos, Size size) {
        this.position = pos;
        this.size = size;
    }

    public Position getCentroid() {
        return this.getPosition().withOffset(this.getSize().getWidth() / 2, this.getSize().getHeight() / 2);
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public boolean mousePressed(int mx, int my, int button) {
        if (this.canStartDrag() && this.isInBounds(mx, my)) {
            this.dragging = true;
            this.dragStart.setXY(mx, my);
            this.dragOffset.setXY(mx - this.getPosition().getX(), my - this.getPosition().getY());
            this.onDragStarted(mx, my);
            return true;
        }
        return this.isInBounds(mx, my);
    }

    public boolean canStartDrag() {
        return this.isDraggable() && Screen.func_231174_t_();
    }

    public boolean isInBounds(int mx, int my) {
        return this.getSize().contains(this.getPosition(), mx, my);
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public boolean mouseDragged(int mx, int my, int button, int dmx, int dmy) {
        if (this.dragging) {
            int newX = mx - this.dragOffset.getX();
            int newY = my - this.dragOffset.getY();
            if (!Config.Client.allowElementsOutOfBounds) {
                newX = MathHelper.func_76125_a((int)newX, (int)0, (int)(512 - this.size.getWidth()));
                newY = MathHelper.func_76125_a((int)newY, (int)0, (int)(256 - this.size.getHeight()));
            }
            if (Screen.func_231173_s_() || Config.Client.alwaysSnapMovementToGrid) {
                newX -= newX % 5;
                newY -= newY % 5;
            }
            int dx = this.getPosition().getX() - this.dragStart.getX() + this.dragOffset.getX();
            int dy = this.getPosition().getY() - this.dragStart.getY() + this.dragOffset.getY();
            this.getPosition().setXY(newX, newY);
            this.onDrag(dx, dy, mx, my);
            return true;
        }
        return false;
    }

    public void onDrag(int dx, int dy, int mx, int my) {
    }

    public void onDragStarted(int mx, int my) {
    }

    public boolean mouseReleased(int mx, int my, int button) {
        if (this.dragging) {
            this.dragging = false;
            if (!this.dragStart.equals(this.getPosition())) {
                this.onDragFinished(this.getPosition().getX() - this.dragStart.getX() + this.dragOffset.getX(), this.getPosition().getY() - this.dragStart.getY() + this.dragOffset.getY(), mx, my);
            }
            return true;
        }
        return false;
    }

    public void onDragFinished(int dx, int dy, int mx, int my) {
    }

    public String toString() {
        return "FlowComponent{visible=" + this.visible + ", enabled=" + this.enabled + ", position=" + this.position + ", size=" + this.size + '}';
    }

    public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
    }

    public void drawTooltip(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        if (this.isTooltipEnabled(mx, my)) {
            screen.pauseScissor();
            Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_().func_226601_d_();
            Vector4f pos = new Vector4f((float)mx, (float)my, 0.0f, 1.0f);
            pos.func_229372_a_(mat);
            GuiUtils.drawHoveringText((MatrixStack)new MatrixStack(), this.getTooltip(), (int)((int)pos.func_195910_a()), (int)((int)pos.func_195913_b()), (int)screen.field_230708_k_, (int)screen.field_230709_l_, (int)-1, (FontRenderer)screen.getFontRenderer());
            screen.resumeScissor();
        }
    }

    public boolean isTooltipEnabled(int mx, int my) {
        return this.isHovering();
    }

    public List<? extends ITextProperties> getTooltip() {
        return new ArrayList();
    }

    public boolean isHovering() {
        return this.hovering;
    }

    public Stream<? extends FlowComponent> getElementsUnderMouse(int mx, int my) {
        return this.isElementUnderMouse(mx, my) ? Stream.of(this) : Stream.empty();
    }

    public boolean isElementUnderMouse(int mx, int my) {
        return this.isVisible() && this.isEnabled() && this.isInBounds(mx, my);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setVisibleAndEnabled(boolean visible) {
        this.setVisible(visible);
        this.setEnabled(visible);
    }

    public void toggleVisibilityAndEnabled() {
        this.setVisible(!this.isVisible());
        this.setEnabled(this.isVisible());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers, int mx, int my) {
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers, int mx, int my) {
        return false;
    }

    public boolean mouseScrolled(int mx, int my, double scroll) {
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers, int mx, int my) {
        return false;
    }

    public void tick() {
    }

    public Position snapToEdge(Position outside) {
        return new Position(MathHelper.func_76125_a((int)outside.getX(), (int)this.getPosition().getX(), (int)(this.getPosition().getX() + this.getSize().getWidth())), MathHelper.func_76125_a((int)outside.getY(), (int)this.getPosition().getY(), (int)(this.getPosition().getY() + this.getSize().getHeight())));
    }

    public int getZIndex() {
        return 0;
    }

    public void drawGhost(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
    }

    public boolean mouseMoved(int mx, int my, boolean consumed) {
        this.hovering = !consumed && this.isInBounds(mx, my);
        return this.hovering;
    }
}

