/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.core;

import ca.teamdman.sfm.common.flow.core.Position;

public class Size {
    private int width;
    private int height;

    public Size(Size copy) {
        this(copy.getWidth(), copy.getHeight());
    }

    public Size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Size toImmutable() {
        return new ImmutableSize(this);
    }

    public Size copy() {
        return new Size(this);
    }

    public void setSize(Size other) {
        this.setSize(other.getWidth(), other.getHeight());
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public boolean contains(Position myPosition, int x, int y) {
        return x >= myPosition.getX() && x <= myPosition.getX() + this.getWidth() && y >= myPosition.getY() && y <= myPosition.getY() + this.getHeight();
    }

    public Size withConstantHeight(final int height) {
        return new Size(0, 0){

            @Override
            public int getWidth() {
                return Size.this.getWidth();
            }

            @Override
            public int getHeight() {
                return height;
            }
        };
    }

    public Size withConstantWidth(final int width) {
        return new Size(0, 0){

            @Override
            public int getWidth() {
                return width;
            }

            @Override
            public int getHeight() {
                return Size.this.getHeight();
            }
        };
    }

    public Size toMutable() {
        return this;
    }

    public String toString() {
        return "Size[" + this.getWidth() + ", " + this.getHeight() + ']';
    }

    public static class ImmutableSize
    extends Size {
        public ImmutableSize(Size copy) {
            super(copy);
        }

        @Override
        public void setWidth(int width) {
            super.setWidth(width);
        }

        @Override
        public void setHeight(int height) {
            super.setHeight(height);
        }

        @Override
        public Size toMutable() {
            return new Size(this);
        }
    }
}

