/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.manager.core;

import ca.teamdman.sfm.client.gui.flow.core.Size;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.CloneController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.DebugController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.DeletionController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.RelationshipController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.FlowToolbox;
import ca.teamdman.sfm.client.gui.flow.impl.manager.template.FlowInstructions;
import ca.teamdman.sfm.client.gui.flow.impl.manager.template.SettingsFlowButton;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowBackground;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowContainer;
import ca.teamdman.sfm.client.gui.screen.ManagerScreen;
import ca.teamdman.sfm.common.config.Config;
import ca.teamdman.sfm.common.flow.core.FlowDataHolder;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.data.CursorFlowData;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.ToolboxFlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.entity.player.ClientPlayerEntity;

public class ManagerFlowController
extends FlowContainer
implements Observer {
    public final ManagerScreen SCREEN;

    public ManagerFlowController(ManagerScreen screen) {
        super(new Position(), new Size(screen.getScaledWidth(), screen.getScaledHeight()));
        this.SCREEN = screen;
        screen.getFlowDataContainer().addObserver(this);
        this.rebuildChildren();
    }

    public void rebuildChildren() {
        this.getChildren().clear();
        this.addChild(new FlowBackground());
        this.addChild(new FlowInstructions(new Position(506, 212)));
        this.addChild(new DebugController(this));
        this.addChild(new CloneController(this));
        this.addChild(new DeletionController(this));
        this.addChild(new RelationshipController(this));
        this.addChild(new SettingsFlowButton(this.SCREEN));
        this.getDataSortedByDependencies().map(data -> data.createController(this)).filter(Objects::nonNull).forEach(this::addChild);
    }

    private Stream<FlowData> getDataSortedByDependencies() {
        Stream.Builder<FlowData> result = Stream.builder();
        List present = this.SCREEN.getFlowDataContainer().stream().collect(Collectors.toList());
        Predicate<Class> isPresent = dep -> present.stream().anyMatch(dep::isInstance);
        Predicate<FlowData> hasDependencyPresent = data -> data.getDependencies().stream().anyMatch(isPresent);
        HashMap dependencies = this.SCREEN.getFlowDataContainer().stream().collect(HashMap::new, (map, data) -> map.put(data, data.getDependencies().stream().filter(isPresent).collect(Collectors.toSet())), HashMap::putAll);
        dependencies.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty());
        ArrayDeque remaining = this.SCREEN.getFlowDataContainer().stream().filter(hasDependencyPresent.negate()).collect(ArrayDeque::new, ArrayDeque::add, AbstractCollection::addAll);
        while (!remaining.isEmpty()) {
            FlowData n = (FlowData)remaining.pop();
            result.add(n);
            Iterator iter = dependencies.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry2 = iter.next();
                ((Set)entry2.getValue()).removeIf(dep -> dep.isInstance(n));
                if (((Set)entry2.getValue()).size() != 0) continue;
                remaining.add(entry2.getKey());
                iter.remove();
            }
        }
        if (dependencies.size() > 0) {
            throw new IllegalArgumentException("Circular FlowData dependency chain detected");
        }
        return result.build();
    }

    @Override
    public boolean mousePressed(int mx, int my, int button) {
        return super.mousePressed(mx, my, button);
    }

    @Override
    public boolean mouseReleased(int mx, int my, int button) {
        if (super.mouseReleased(mx, my, button)) {
            return true;
        }
        if (this.isInBounds(mx, my)) {
            this.findFirstChild(FlowToolbox.class).ifPresent(FlowToolbox::setChildrenToDefault);
            return true;
        }
        return false;
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers, int mx, int my) {
        if (super.keyReleased(keyCode, scanCode, modifiers, mx, my)) {
            return true;
        }
        if (!Config.Client.preventClosingManagerWithInventoryButton && this.SCREEN.getMinecraft().field_71474_y.field_151445_Q.func_197976_a(keyCode, scanCode)) {
            this.SCREEN.func_231175_as__();
            return true;
        }
        return false;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof BasicFlowDataContainer.FlowDataContainerChange) {
            BasicFlowDataContainer.FlowDataContainerChange change = (BasicFlowDataContainer.FlowDataContainerChange)arg;
            if (change.CHANGE == BasicFlowDataContainer.FlowDataContainerChange.ChangeType.REMOVED) {
                this.getChildren().stream().filter(FlowDataHolder.class::isInstance).filter(c -> ((FlowData)((FlowDataHolder)((Object)c)).getData()).getId().equals(change.DATA.getId())).collect(Collectors.toList()).forEach(this::removeChild);
            } else if (change.CHANGE == BasicFlowDataContainer.FlowDataContainerChange.ChangeType.ADDED) {
                this.addChild(change.DATA.createController(this));
            }
        } else if (arg instanceof BasicFlowDataContainer.FlowDataContainerClosedClientEvent) {
            o.deleteObserver(this);
        }
    }

    public void init() {
        this.createPlayerCursor();
        this.createToolbox();
    }

    public void createPlayerCursor() {
        ClientPlayerEntity localPlayer = this.SCREEN.getMinecraft().field_71439_g;
        this.SCREEN.getFlowDataContainer().get(localPlayer.func_110124_au(), CursorFlowData.class).orElseGet(() -> {
            CursorFlowData next = new CursorFlowData(localPlayer.func_110124_au(), localPlayer.func_195047_I_(), new Position());
            this.SCREEN.sendFlowDataToServer(next);
            return next;
        });
    }

    public void createToolbox() {
        this.SCREEN.getFlowDataContainer().get(ToolboxFlowData.class).findAny().orElseGet(() -> {
            ToolboxFlowData data = new ToolboxFlowData(UUID.randomUUID(), new Position());
            this.SCREEN.sendFlowDataToServer(data);
            return data;
        });
    }
}

