/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder;

import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.Colour3f;
import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.core.Size;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.common.flow.core.FlowDataHolder;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.data.CursorFlowData;
import ca.teamdman.sfm.common.flow.holder.FlowDataHolderObserver;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class FlowCursor
extends FlowComponent
implements FlowDataHolder<CursorFlowData> {
    private final ManagerFlowController CONTROLLER;
    private CursorFlowData data;
    private int debounce = 0;

    public FlowCursor(ManagerFlowController CONTROLLER, CursorFlowData data) {
        super(new Position(0, 0), new Size(8, 8));
        this.CONTROLLER = CONTROLLER;
        this.data = data;
        CONTROLLER.SCREEN.getFlowDataContainer().addObserver(new FlowDataHolderObserver<CursorFlowData>(CursorFlowData.class, this));
    }

    @Override
    public boolean mousePressed(int mx, int my, int button) {
        return false;
    }

    @Override
    public void drawTooltip(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        screen.drawRect(matrixStack, this.getPosition().getX(), this.getPosition().getY(), this.getSize().getWidth(), this.getSize().getHeight(), Colour3f.CONST.CURSOR);
        super.drawTooltip(screen, matrixStack, mx, my, deltaTime);
    }

    @Override
    public List<? extends ITextProperties> getTooltip() {
        return Collections.singletonList(new StringTextComponent(this.data.playerName));
    }

    @Override
    public boolean isVisible() {
        return !this.belongsToLocalPlayer();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void tick() {
        if (this.debounce > 0) {
            --this.debounce;
        }
    }

    @Override
    public int getZIndex() {
        return super.getZIndex() + 32000;
    }

    @Override
    public boolean mouseMoved(int mx, int my, boolean consumed) {
        if (this.belongsToLocalPlayer() && this.debounce == 0) {
            this.data.position.setXY(mx, my);
            this.CONTROLLER.SCREEN.sendFlowDataToServer(this.data);
            this.debounce = 2;
        }
        return super.mouseMoved(mx, my, consumed) && this.isVisible();
    }

    public boolean belongsToLocalPlayer() {
        ClientPlayerEntity player = this.CONTROLLER.SCREEN.getMinecraft().field_71439_g;
        if (player == null) {
            return false;
        }
        return Objects.equals(this.data.getId(), player.func_110124_au());
    }

    @Override
    public CursorFlowData getData() {
        return this.data;
    }

    @Override
    public void setData(CursorFlowData data) {
        this.data = data;
        this.getPosition().setXY(data.position);
    }
}

