/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder;

import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.Colour3f;
import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.ConditionLineNodeFlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.ItemConditionFlowButton;
import ca.teamdman.sfm.client.gui.flow.impl.util.ButtonBackground;
import ca.teamdman.sfm.common.flow.core.FlowDataHolder;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.data.RelationshipFlowData;
import ca.teamdman.sfm.common.net.PacketHandler;
import ca.teamdman.sfm.common.net.packet.manager.put.ManagerCreateLineNodePacketC2S;
import ca.teamdman.sfm.common.tile.manager.ManagerTileEntity;
import ca.teamdman.sfm.common.util.SFMUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.gui.screen.Screen;

public class FlowRelationship
extends FlowComponent
implements FlowDataHolder<RelationshipFlowData> {
    public static final Colour3f COLOUR = new Colour3f(0.4f, 0.4f, 0.4f);
    public final ManagerFlowController CONTROLLER;
    private RelationshipFlowData data;

    public FlowRelationship(ManagerFlowController CONTROLLER, RelationshipFlowData data) {
        this.CONTROLLER = CONTROLLER;
        this.data = data;
    }

    @Override
    public boolean mousePressed(int mx, int my, int button) {
        if (!Screen.func_231172_r_() || this.belongsToConditional()) {
            return false;
        }
        Optional<FlowRelationship> rel = this.CONTROLLER.getChildren().stream().filter(FlowRelationship.class::isInstance).map(FlowRelationship.class::cast).filter(r -> r.isCloseTo(mx, my)).findFirst();
        if (!rel.isPresent()) {
            return false;
        }
        PacketHandler.INSTANCE.sendToServer((Object)new ManagerCreateLineNodePacketC2S(this.CONTROLLER.SCREEN.getContainer().field_75152_c, ((ManagerTileEntity)((Object)this.CONTROLLER.SCREEN.getContainer().getSource())).func_174877_v(), rel.get().data.from, rel.get().data.to, new Position(mx - ButtonBackground.LINE_NODE.WIDTH / 2, my - ButtonBackground.LINE_NODE.HEIGHT / 2)));
        return true;
    }

    @Override
    public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        this.draw(screen, matrixStack, COLOUR);
    }

    @Override
    public Stream<? extends FlowComponent> getElementsUnderMouse(int mx, int my) {
        return this.isCloseTo(mx, my) ? Stream.of(this) : Stream.empty();
    }

    @Override
    public int getZIndex() {
        return super.getZIndex() - 200;
    }

    public void draw(BaseScreen screen, MatrixStack matrixStack, Colour3f colour) {
        this.getPositions().ifPresent(pair -> screen.drawArrow(matrixStack, pair.FROM, pair.TO, colour));
    }

    public boolean isCloseTo(int x, int y) {
        return this.getDistance(x, y) < 3.0;
    }

    public double getDistance(int x, int y) {
        Optional<FlowRelationshipPositionPair> pair = this.getPositions();
        if (!pair.isPresent()) {
            return Double.MAX_VALUE;
        }
        Position from = pair.get().FROM;
        Position to = pair.get().TO;
        return SFMUtil.getDistanceFromLine(x, y, from.getX(), from.getY(), to.getX(), to.getY());
    }

    public Optional<FlowRelationshipPositionPair> getPositions() {
        Optional<FlowComponent> from = this.CONTROLLER.findFirstChild(this.data.from);
        Optional<FlowComponent> to = this.CONTROLLER.findFirstChild(this.data.to);
        return from.filter(__ -> to.isPresent()).map(fromShape -> new FlowRelationshipPositionPair(fromShape.getCentroid(), ((FlowComponent)to.get()).snapToEdge(fromShape.getCentroid())));
    }

    @Override
    public RelationshipFlowData getData() {
        return this.data;
    }

    @Override
    public void setData(RelationshipFlowData data) {
        this.data = data;
    }

    @Override
    public boolean isDeletable() {
        return !this.belongsToConditional();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean belongsToConditional() {
        if (!this.CONTROLLER.findFirstChild(this.data.to).filter(ConditionLineNodeFlowComponent.class::isInstance).isPresent()) return false;
        if (!this.CONTROLLER.findFirstChild(this.data.from).filter(ItemConditionFlowButton.class::isInstance).isPresent()) return false;
        return true;
    }

    public static class FlowRelationshipPositionPair {
        final Position FROM;
        final Position TO;

        public FlowRelationshipPositionPair(Position FROM, Position TO) {
            this.FROM = FROM;
            this.TO = TO;
        }
    }
}

