/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder;

import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.Colour3f;
import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.core.Size;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.template.toolboxspawner.FlowTimerTriggerSpawnerButton;
import ca.teamdman.sfm.client.gui.flow.impl.manager.template.toolboxspawner.ItemConditionSpawnerFlowButton;
import ca.teamdman.sfm.client.gui.flow.impl.manager.template.toolboxspawner.ItemInputSpawnerFlowButton;
import ca.teamdman.sfm.client.gui.flow.impl.manager.template.toolboxspawner.ItemOutputSpawnerFlowButton;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowContainer;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowDrawer;
import ca.teamdman.sfm.common.flow.core.FlowDataHolder;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.data.ToolboxFlowData;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import net.minecraft.client.resources.I18n;

public class FlowToolbox
extends FlowContainer
implements FlowDataHolder<ToolboxFlowData> {
    private final ManagerFlowController CONTROLLER;
    private final FlowDrawer DRAWER;
    private ToolboxFlowData data;
    private String title;

    public FlowToolbox(ManagerFlowController controller, ToolboxFlowData data) {
        super(data.getPosition(), new Size(100, 30));
        this.data = data;
        this.CONTROLLER = controller;
        this.title = I18n.func_135052_a((String)"gui.sfm.toolbox.title.default", (Object[])new Object[0]);
        this.DRAWER = new FlowDrawer(new Position(0, 30), 1, 10);
        this.addChild(this.DRAWER);
        this.setDraggable(true);
        this.setChildrenToDefault();
    }

    public void setChildrenToDefault() {
        this.DRAWER.getChildren().clear();
        this.DRAWER.addChild(new FlowTimerTriggerSpawnerButton(this.CONTROLLER));
        this.DRAWER.addChild(new ItemInputSpawnerFlowButton(this.CONTROLLER));
        this.DRAWER.addChild(new ItemOutputSpawnerFlowButton(this.CONTROLLER));
        this.DRAWER.addChild(new ItemConditionSpawnerFlowButton(this.CONTROLLER));
        this.DRAWER.setMaxItemsPerRow(4);
        this.DRAWER.setMaxItemsPerColumn(3);
        this.DRAWER.update();
    }

    public void setDrawerChildren(Collection<FlowComponent> children) {
        this.DRAWER.getChildren().clear();
        children.forEach(this.DRAWER::addChild);
        this.DRAWER.update();
    }

    @Override
    public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        screen.drawRect(matrixStack, this.getPosition().getX(), this.getPosition().getY(), this.getSize().getWidth(), this.getSize().getHeight(), Colour3f.CONST.PANEL_BACKGROUND_NORMAL);
        screen.drawBorder(matrixStack, this.getPosition().getX(), this.getPosition().getY(), this.getSize().getWidth(), this.getSize().getHeight(), 1, Colour3f.CONST.PANEL_BORDER);
        screen.drawString(matrixStack, this.title, this.getPosition().getX() + 5, this.getPosition().getY() + 5, Colour3f.CONST.TEXT_LIGHT);
        super.draw(screen, matrixStack, mx, my, deltaTime);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public int getZIndex() {
        return super.getZIndex() + 250;
    }

    @Override
    public ToolboxFlowData getData() {
        return this.data;
    }

    @Override
    public void setData(ToolboxFlowData data) {
        this.data = data;
        this.setPosition(data.getPosition());
    }

    @Override
    public void onDragFinished(int dx, int dy, int mx, int my) {
        this.CONTROLLER.SCREEN.sendFlowDataToServer(this.data);
    }
}

