/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder;

import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.util.ButtonLabel;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowContainer;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowIconButton;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowSprite;
import ca.teamdman.sfm.common.flow.core.FlowDataHolder;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.data.ConditionLineNodeFlowData;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.ItemConditionFlowData;
import ca.teamdman.sfm.common.flow.data.ItemConditionRuleFlowData;
import ca.teamdman.sfm.common.flow.holder.FlowDataHolderObserver;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class ItemConditionFlowButton
extends FlowContainer
implements FlowDataHolder<ItemConditionFlowData> {
    private final ManagerFlowController CONTROLLER;
    private final MyFlowIconButton BUTTON;
    private ItemConditionRuleFlowData ruleData;
    private ItemConditionFlowData buttonData;

    public ItemConditionFlowButton(ManagerFlowController controller, ItemConditionFlowData buttonData, ItemConditionRuleFlowData ruleData) {
        this.buttonData = buttonData;
        this.ruleData = ruleData;
        this.CONTROLLER = controller;
        this.BUTTON = new MyFlowIconButton(ButtonLabel.CONDITIONAL, buttonData.getPosition().copy());
        this.BUTTON.setDraggable(true);
        this.BUTTON.reloadFromRuleData();
        this.addChild(this.BUTTON);
        controller.SCREEN.getFlowDataContainer().addObserver(new FlowDataHolderObserver<ItemConditionFlowData>(ItemConditionFlowData.class, this));
        controller.SCREEN.getFlowDataContainer().addObserver(new FlowDataHolderObserver<ItemConditionRuleFlowData>(ItemConditionRuleFlowData.class, data -> data.getId().equals(ruleData.getId()), this::setRuleData));
    }

    public void setRuleData(ItemConditionRuleFlowData data) {
        this.ruleData = data;
        this.BUTTON.reloadFromRuleData();
    }

    @Override
    public Position getCentroid() {
        return this.BUTTON.getCentroid();
    }

    @Override
    public Position snapToEdge(Position outside) {
        return this.BUTTON.snapToEdge(outside);
    }

    @Override
    public Stream<? extends FlowComponent> getElementsUnderMouse(int mx, int my) {
        return this.BUTTON.isElementUnderMouse(mx, my) ? Stream.of(this) : Stream.empty();
    }

    public Stream<ConditionLineNodeFlowData> getNodes() {
        return this.CONTROLLER.SCREEN.getFlowDataContainer().get(ConditionLineNodeFlowData.class).filter(this::ownsNode);
    }

    public boolean ownsNode(ConditionLineNodeFlowData node) {
        return this.CONTROLLER.SCREEN.getFlowDataContainer().getAncestors(node.getId(), false).anyMatch(parent -> parent.equals(this.getData().getId()));
    }

    @Override
    public ItemConditionFlowData getData() {
        return this.buttonData;
    }

    @Override
    public void setData(ItemConditionFlowData data) {
        this.buttonData = data;
        this.BUTTON.getPosition().setXY(this.buttonData.getPosition());
    }

    @Override
    public boolean isDeletable() {
        return true;
    }

    @Override
    public boolean isCloneable() {
        return true;
    }

    private class MyFlowIconButton
    extends FlowIconButton {
        private final HashMap<ConditionLineNodeFlowData, Position> OFFSETS;

        @Override
        public int getZIndex() {
            return super.getZIndex() + 10;
        }

        public MyFlowIconButton(ButtonLabel type, Position pos) {
            super(type, pos);
            this.OFFSETS = new HashMap();
        }

        @Override
        public void onClicked(int mx, int my, int button) {
            ItemConditionFlowButton.this.CONTROLLER.findFirstChild(((ItemConditionFlowButton)ItemConditionFlowButton.this).buttonData.rule).ifPresent(FlowComponent::toggleVisibilityAndEnabled);
        }

        @Override
        public void onDrag(int dx, int dy, int mx, int my) {
            ItemConditionFlowButton.this.getNodes().filter(this.OFFSETS::containsKey).forEach(node -> node.getPosition().setXY(this.getPosition().subtract(this.OFFSETS.get(node))));
        }

        @Override
        public void onDragStarted(int mx, int my) {
            ItemConditionFlowButton.this.getNodes().forEach(node -> this.OFFSETS.put((ConditionLineNodeFlowData)node, this.getPosition().subtract(node.getPosition())));
        }

        @Override
        public void onDragFinished(int dx, int dy, int mx, int my) {
            ArrayList<FlowData> changed = new ArrayList<FlowData>();
            ItemConditionFlowButton.this.getNodes().filter(this.OFFSETS::containsKey).peek(node -> node.getPosition().setXY(this.getPosition().subtract(this.OFFSETS.get(node)))).forEach(changed::add);
            ((ItemConditionFlowButton)ItemConditionFlowButton.this).buttonData.position = this.getPosition();
            changed.add(ItemConditionFlowButton.this.buttonData);
            ((ItemConditionFlowButton)ItemConditionFlowButton.this).CONTROLLER.SCREEN.sendFlowDataToServer(changed);
            this.OFFSETS.clear();
        }

        @Override
        public List<? extends ITextProperties> getTooltip() {
            return Collections.singletonList(new StringTextComponent(((ItemConditionFlowButton)ItemConditionFlowButton.this).ruleData.name));
        }

        public void reloadFromRuleData() {
            this.LABEL = ItemConditionFlowButton.this.ruleData.getIcon().func_190926_b() ? ButtonLabel.CONDITIONAL.SPRITE : FlowSprite.EMPTY;
        }

        @Override
        public void drawGhost(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
            super.drawGhost(screen, matrixStack, mx, my, deltaTime);
            if (this.LABEL == FlowSprite.EMPTY) {
                screen.drawItemStack(matrixStack, ItemConditionFlowButton.this.ruleData.getIcon(), this.getPosition().getX() + 3, this.getPosition().getY() + 3);
            }
        }

        @Override
        protected boolean isDepressed() {
            return super.isDepressed() || ((ItemConditionFlowButton)ItemConditionFlowButton.this).ruleData.open;
        }

        @Override
        public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
            if (this.LABEL == FlowSprite.EMPTY) {
                RenderSystem.color4f((float)0.9f, (float)0.5f, (float)0.5f, (float)1.0f);
            }
            super.draw(screen, matrixStack, mx, my, deltaTime);
            if (this.LABEL == FlowSprite.EMPTY) {
                screen.drawItemStack(matrixStack, ItemConditionFlowButton.this.ruleData.getIcon(), this.getPosition().getX() + 3, this.getPosition().getY() + 3);
            }
        }
    }
}

