/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder;

import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.util.ButtonLabel;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowContainer;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowIconButton;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowSprite;
import ca.teamdman.sfm.common.flow.core.FlowDataHolder;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.data.ItemMovementRuleFlowData;
import ca.teamdman.sfm.common.flow.data.ItemOutputFlowData;
import ca.teamdman.sfm.common.flow.holder.FlowDataHolderObserver;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class ItemOutputFlowButton
extends FlowContainer
implements FlowDataHolder<ItemOutputFlowData> {
    private final ManagerFlowController CONTROLLER;
    private final MyFlowIconButton BUTTON;
    private ItemMovementRuleFlowData ruleData;
    private ItemOutputFlowData buttonData;

    public ItemOutputFlowButton(ManagerFlowController controller, ItemOutputFlowData buttonData, ItemMovementRuleFlowData ruleData) {
        this.buttonData = buttonData;
        this.ruleData = ruleData;
        this.CONTROLLER = controller;
        this.BUTTON = new MyFlowIconButton(ButtonLabel.OUTPUT, buttonData.getPosition().copy());
        this.BUTTON.setDraggable(true);
        this.BUTTON.reloadFromRuleData();
        this.addChild(this.BUTTON);
        controller.SCREEN.getFlowDataContainer().addObserver(new FlowDataHolderObserver<ItemOutputFlowData>(ItemOutputFlowData.class, this));
        controller.SCREEN.getFlowDataContainer().addObserver(new FlowDataHolderObserver<ItemMovementRuleFlowData>(ItemMovementRuleFlowData.class, data -> data.getId().equals(ruleData.getId()), this::setRuleData));
    }

    public void setRuleData(ItemMovementRuleFlowData data) {
        this.ruleData = data;
        this.BUTTON.reloadFromRuleData();
    }

    @Override
    public ItemOutputFlowData getData() {
        return this.buttonData;
    }

    @Override
    public void setData(ItemOutputFlowData data) {
        this.buttonData = data;
        this.BUTTON.getPosition().setXY(this.buttonData.getPosition());
    }

    @Override
    public boolean isDeletable() {
        return true;
    }

    @Override
    public boolean isCloneable() {
        return true;
    }

    @Override
    public Position getCentroid() {
        return this.BUTTON.getCentroid();
    }

    @Override
    public Position snapToEdge(Position outside) {
        return this.BUTTON.snapToEdge(outside);
    }

    @Override
    public Stream<? extends FlowComponent> getElementsUnderMouse(int mx, int my) {
        return this.BUTTON.isElementUnderMouse(mx, my) ? Stream.of(this) : Stream.empty();
    }

    private class MyFlowIconButton
    extends FlowIconButton {
        public MyFlowIconButton(ButtonLabel type, Position pos) {
            super(type, pos);
        }

        @Override
        public void onClicked(int mx, int my, int button) {
            ItemOutputFlowButton.this.CONTROLLER.findFirstChild(((ItemOutputFlowButton)ItemOutputFlowButton.this).buttonData.tileEntityRule).ifPresent(FlowComponent::toggleVisibilityAndEnabled);
        }

        @Override
        public void onDragFinished(int dx, int dy, int mx, int my) {
            ((ItemOutputFlowButton)ItemOutputFlowButton.this).buttonData.position = this.getPosition();
            ((ItemOutputFlowButton)ItemOutputFlowButton.this).CONTROLLER.SCREEN.sendFlowDataToServer(ItemOutputFlowButton.this.buttonData);
        }

        @Override
        public List<? extends ITextProperties> getTooltip() {
            return Collections.singletonList(new StringTextComponent(((ItemOutputFlowButton)ItemOutputFlowButton.this).ruleData.name));
        }

        public void reloadFromRuleData() {
            this.LABEL = ItemOutputFlowButton.this.ruleData.getIcon().func_190926_b() ? ButtonLabel.OUTPUT.SPRITE : FlowSprite.EMPTY;
        }

        @Override
        public void drawGhost(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
            super.drawGhost(screen, matrixStack, mx, my, deltaTime);
            if (this.LABEL == FlowSprite.EMPTY) {
                screen.drawItemStack(matrixStack, ItemOutputFlowButton.this.ruleData.getIcon(), this.getPosition().getX() + 3, this.getPosition().getY() + 3);
            }
        }

        @Override
        protected boolean isDepressed() {
            return super.isDepressed() || ((ItemOutputFlowButton)ItemOutputFlowButton.this).ruleData.open;
        }

        @Override
        public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
            if (this.LABEL == FlowSprite.EMPTY) {
                RenderSystem.color4f((float)1.0f, (float)0.6f, (float)0.4f, (float)1.0f);
            }
            super.draw(screen, matrixStack, mx, my, deltaTime);
            if (this.LABEL == FlowSprite.EMPTY) {
                screen.drawItemStack(matrixStack, ItemOutputFlowButton.this.ruleData.getIcon(), this.getPosition().getX() + 3, this.getPosition().getY() + 3);
            }
        }
    }
}

