/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.itemmovementrule;

import ca.teamdman.sfm.client.gui.flow.core.Colour3f;
import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.core.Size;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.itemmovementrule.ItemMovementRuleFlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.itemmovementrule.SectionHeader;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.itemmovementrule.TileMatcherDrawerItem;
import ca.teamdman.sfm.client.gui.flow.impl.manager.template.tilematcherspawner.TileMatcherSpawnerDrawer;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowContainer;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowDrawer;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowPlusButton;
import ca.teamdman.sfm.client.gui.flow.impl.util.ItemStackFlowButton;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.flow.core.FlowDataHolder;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.core.TileMatcher;
import ca.teamdman.sfm.common.flow.data.ItemMovementRuleFlowData;
import ca.teamdman.sfm.common.tile.manager.ManagerTileEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

class TilesSection
extends FlowContainer {
    protected final FlowDrawer DRAWER;
    protected final ItemMovementRuleFlowComponent PARENT;
    private final TileMatcherSpawnerDrawer ADDER;

    public TilesSection(ItemMovementRuleFlowComponent parent, Position pos) {
        super(pos);
        this.PARENT = parent;
        this.ADDER = new TileMatcherSpawnerDrawer(this.PARENT::addTileMatcher, new Position(ItemStackFlowButton.DEFAULT_SIZE.getWidth() + 5, 15));
        this.ADDER.setVisibleAndEnabled(false);
        this.addChild(this.ADDER);
        this.addChild(new SectionHeader(new Position(0, 0), new Size(35, 12), I18n.func_135052_a((String)"gui.sfm.manager.tile_entity_rule.tiles.title", (Object[])new Object[0])));
        this.DRAWER = new FlowDrawer(new Position(0, 16), 4, 3);
        this.DRAWER.setShrinkToFit(false);
        this.addChild(this.DRAWER);
        this.rebuildChildren();
    }

    public void rebuildChildren() {
        this.DRAWER.getChildren().clear();
        this.DRAWER.addChild(new AddButton());
        ManagerTileEntity tile = (ManagerTileEntity)((Object)this.PARENT.CONTROLLER.SCREEN.getContainer().getSource());
        World world = tile.func_145831_w();
        if (world == null) {
            return;
        }
        CableNetworkManager.getOrRegisterNetwork(world, tile.func_174877_v()).ifPresent(this::getDrawerChildrenFromNetwork);
        this.DRAWER.update();
    }

    private void getDrawerChildrenFromNetwork(CableNetwork network) {
        this.PARENT.getData().tileMatcherIds.stream().map(this.PARENT.CONTROLLER::findFirstChild).filter(Optional::isPresent).map(Optional::get).filter(FlowDataHolder.class::isInstance).filter(c -> ((FlowDataHolder)((Object)c)).getData() instanceof TileMatcher).map(c -> new TileMatcherDrawerItem<FlowComponent>(this, (FlowComponent)c, network)).forEach(this.DRAWER::addChild);
    }

    public void onDataChanged(ItemMovementRuleFlowData data) {
        this.rebuildChildren();
    }

    private class AddButton
    extends FlowPlusButton {
        public AddButton() {
            super(new Position(), ItemStackFlowButton.DEFAULT_SIZE, Colour3f.CONST.ADD_BUTTON);
        }

        @Override
        public void onClicked(int mx, int my, int button) {
            TilesSection.this.ADDER.toggleVisibilityAndEnabled();
        }

        @Override
        public List<? extends ITextProperties> getTooltip() {
            return Arrays.asList(new TranslationTextComponent("gui.sfm.flow.tooltip.add_tile_matcher_1"), new TranslationTextComponent("gui.sfm.flow.tooltip.add_tile_matcher_2").func_240699_a_(TextFormatting.GRAY));
        }
    }
}

