/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.itempickermatcher;

import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.Colour3f;
import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.core.Size;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.itempickermatcher.StackIconButton;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowContainer;
import ca.teamdman.sfm.client.gui.flow.impl.util.ItemStackFlowButton;
import ca.teamdman.sfm.client.gui.flow.impl.util.TextAreaFlowComponent;
import ca.teamdman.sfm.common.flow.core.FlowDataHolder;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.data.ItemPickerMatcherFlowData;
import ca.teamdman.sfm.common.flow.holder.FlowDataHolderObserver;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;

public class ItemPickerMatcherFlowComponent
extends FlowContainer
implements FlowDataHolder<ItemPickerMatcherFlowData> {
    protected final ManagerFlowController PARENT;
    private final StackIconButton ICON;
    private final TextAreaFlowComponent QUANTITY_INPUT;
    private ItemPickerMatcherFlowData data;

    public ItemPickerMatcherFlowComponent(ManagerFlowController parent, ItemPickerMatcherFlowData data) {
        super(new Position(ItemStackFlowButton.DEFAULT_SIZE.getWidth() + 5, 0), new Size(100, 24));
        this.PARENT = parent;
        this.data = data;
        this.QUANTITY_INPUT = new TextAreaFlowComponent(parent.SCREEN, data.getDisplayQuantity(), "#", new Position(4, 4), new Size(38, 16)){

            @Override
            public void clear() {
                this.delegate.func_146180_a("0");
            }
        };
        this.QUANTITY_INPUT.setValidator(next -> Objects.nonNull(next) && next.matches("\\d*"));
        this.QUANTITY_INPUT.setResponder(next -> {
            try {
                int nextVal = Integer.parseInt(next);
                if (nextVal != data.quantity) {
                    data.quantity = nextVal;
                    parent.SCREEN.sendFlowDataToServer(data);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.addChild(this.QUANTITY_INPUT);
        this.addChild(new FlowComponent(new Position(45, 8), new Size(0, 0)){

            @Override
            public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
                screen.drawString(matrixStack, "x", this.getPosition().getX(), this.getPosition().getY(), Colour3f.CONST.TEXT_DARK);
            }
        });
        this.ICON = new StackIconButton(this, new Position(54, 2));
        this.addChild(this.ICON);
        parent.SCREEN.getFlowDataContainer().addObserver(new FlowDataHolderObserver<ItemPickerMatcherFlowData>(ItemPickerMatcherFlowData.class, this));
    }

    @Override
    public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        screen.clearRect(matrixStack, this.getPosition().getX(), this.getPosition().getY(), this.getSize().getWidth(), this.getSize().getHeight());
        screen.drawRect(matrixStack, this.getPosition().getX(), this.getPosition().getY(), this.getSize().getWidth(), this.getSize().getHeight(), Colour3f.CONST.PANEL_BACKGROUND_LIGHT);
        super.draw(screen, matrixStack, mx, my, deltaTime);
    }

    @Override
    public ItemPickerMatcherFlowData getData() {
        return this.data;
    }

    @Override
    public boolean isVisible() {
        return this.data.open;
    }

    @Override
    public void setData(ItemPickerMatcherFlowData data) {
        this.data = data;
        this.ICON.BUTTON.setItemStack(data.stack);
        this.QUANTITY_INPUT.setContent(Integer.toString(data.quantity));
    }

    @Override
    public boolean isEnabled() {
        return this.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.data.open != visible) {
            this.data.open = visible;
            this.PARENT.SCREEN.sendFlowDataToServer(this.data);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setVisible(enabled);
    }

    @Override
    public int getZIndex() {
        return super.getZIndex() + 120;
    }
}

