/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.tilepositionmatcher;

import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.util.BlockPosPickerFlowComponent;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.data.ItemMovementRuleFlowData;
import ca.teamdman.sfm.common.flow.data.TilePositionMatcherFlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

class Picker
extends BlockPosPickerFlowComponent {
    private final TilePositionMatcherFlowData data;
    private final ManagerFlowController PARENT;

    public Picker(TilePositionMatcherFlowData data, ManagerFlowController parent, Position position) {
        super(position);
        this.data = data;
        this.PARENT = parent;
        this.rebuildSuggestions();
    }

    public void rebuildSuggestions() {
        BasicFlowDataContainer container = this.PARENT.SCREEN.getFlowDataContainer();
        Set ignore = container.get(ItemMovementRuleFlowData.class).filter(data -> data.tileMatcherIds.contains(this.data.getId())).flatMap(data -> data.tileMatcherIds.stream()).map(id -> container.get((UUID)id, TilePositionMatcherFlowData.class)).filter(Optional::isPresent).map(Optional::get).map(data -> data.position).collect(Collectors.toSet());
        CableNetworkManager.getOrRegisterNetwork((TileEntity)this.PARENT.SCREEN.getContainer().getSource()).ifPresent(net -> this.rebuildFromNetwork((CableNetwork)net, p -> !ignore.contains(p)));
    }

    @Override
    public void onPicked(BlockPos pos) {
        if (!this.data.position.equals((Object)pos)) {
            this.data.position = pos;
            this.PARENT.SCREEN.sendFlowDataToServer(this.data);
        }
        this.setVisibleAndEnabled(false);
    }
}

