/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.manager.util.ruledrawer;

import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.Colour3f;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.util.ruledrawer.ChildRulesDrawerItem;
import ca.teamdman.sfm.client.gui.flow.impl.manager.util.ruledrawer.GlobalRulesDrawerItem;
import ca.teamdman.sfm.client.gui.flow.impl.manager.util.ruledrawer.PlusButton;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowContainer;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowDrawer;
import ca.teamdman.sfm.common.config.Config;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.ItemMovementRuleFlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;

public abstract class ItemStackTileEntityRuleDrawer
extends FlowContainer
implements Observer {
    protected final PlusButton PLUS_BUTTON;
    protected final ManagerFlowController CONTROLLER;
    protected final FlowDrawer DRAWER;
    protected boolean isGlobalOpen = false;
    protected String drawerLabel = I18n.func_135052_a((String)"gui.sfm.associatedrulesdrawer.children.label", (Object[])new Object[0]);

    public ItemStackTileEntityRuleDrawer(ManagerFlowController controller, Position pos) {
        super(pos);
        this.CONTROLLER = controller;
        this.PLUS_BUTTON = new PlusButton(this);
        this.DRAWER = new FlowDrawer(new Position(), 5, 7);
        this.addChild(this.DRAWER);
        this.setVisibleAndEnabled(false);
        this.rebuildDrawer();
        controller.SCREEN.getFlowDataContainer().addObserver(this);
    }

    public void rebuildDrawer() {
        if (this.isGlobalOpen) {
            this.rebuildGlobalDrawer();
            this.drawerLabel = I18n.func_135052_a((String)"gui.sfm.associatedrulesdrawer.selection.label", (Object[])new Object[0]);
        } else {
            this.rebuildChildrenDrawer();
            this.drawerLabel = I18n.func_135052_a((String)"gui.sfm.associatedrulesdrawer.children.label", (Object[])new Object[0]);
        }
    }

    private void rebuildGlobalDrawer() {
        this.DRAWER.getChildren().clear();
        this.DRAWER.addChild(this.PLUS_BUTTON);
        this.CONTROLLER.SCREEN.getFlowDataContainer().get(ItemMovementRuleFlowData.class).collect(Collectors.toList()).stream().map(rule -> new GlobalRulesDrawerItem((ItemMovementRuleFlowData)rule, this)).forEach(this.DRAWER::addChild);
        List<UUID> selected = this.getChildrenRuleIds();
        this.DRAWER.getChildren().stream().filter(c -> c instanceof GlobalRulesDrawerItem).map(c -> (GlobalRulesDrawerItem)c).filter(c -> selected.contains(c.DATA.getId())).forEach(c -> c.setSelected(true));
        this.DRAWER.update();
    }

    private void rebuildChildrenDrawer() {
        this.DRAWER.getChildren().clear();
        this.DRAWER.addChild(this.PLUS_BUTTON);
        this.getChildrenRules().stream().map(rule -> new ChildRulesDrawerItem(this, (ItemMovementRuleFlowData)rule)).forEach(this.DRAWER::addChild);
        this.DRAWER.update();
    }

    public abstract List<ItemMovementRuleFlowData> getChildrenRules();

    protected List<UUID> getChildrenRuleIds() {
        return this.getChildrenRules().stream().map(FlowData::getId).collect(Collectors.toList());
    }

    public abstract FlowData getDataWithNewChildren(List<UUID> var1);

    @Override
    public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        if (Config.Client.showRuleDrawerLabels) {
            int labelHeight = 15;
            screen.drawRect(matrixStack, this.getPosition().getX(), this.getPosition().getY() - labelHeight, this.DRAWER.getMaxWidth(), labelHeight, Colour3f.CONST.PANEL_BORDER);
            screen.drawString(matrixStack, this.drawerLabel, this.getPosition().getX() + 5, this.getPosition().getY() - labelHeight + 4, Colour3f.CONST.TEXT_LIGHT);
        }
        super.draw(screen, matrixStack, mx, my, deltaTime);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof BasicFlowDataContainer.FlowDataContainerChange) {
            BasicFlowDataContainer.FlowDataContainerChange change = (BasicFlowDataContainer.FlowDataContainerChange)arg;
            if (change.DATA instanceof ItemMovementRuleFlowData) {
                this.rebuildDrawer();
            }
        }
    }
}

