/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.util;

import ca.teamdman.sfm.client.gui.flow.impl.util.FlowContainer;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowDrawer;
import ca.teamdman.sfm.client.gui.flow.impl.util.ItemStackFlowButton;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.flow.core.Position;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class BlockPosPickerFlowComponent
extends FlowContainer {
    private final FlowDrawer DRAWER = new FlowDrawer(new Position(0, 0), 5, 7);

    public BlockPosPickerFlowComponent(Position pos) {
        super(pos);
        this.addChild(this.DRAWER);
    }

    private ItemStack getPreview(World world, BlockPos pos) {
        return new ItemStack((IItemProvider)world.func_180495_p(pos).func_177230_c().func_199767_j());
    }

    public void rebuildFromNetwork(CableNetwork network, Predicate<BlockPos> filter) {
        this.DRAWER.getChildren().clear();
        network.getInventories().stream().filter(t -> t.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()).map(TileEntity::func_174877_v).filter(filter).map(pos -> new Entry((BlockPos)pos, this.getPreview(network.getWorld(), (BlockPos)pos))).forEach(this.DRAWER::addChild);
        this.DRAWER.update();
    }

    public abstract void onPicked(BlockPos var1);

    @Override
    public int getZIndex() {
        return super.getZIndex() + 50;
    }

    private class Entry
    extends ItemStackFlowButton {
        public final BlockPos POS;

        public Entry(BlockPos pos, ItemStack stack) {
            super(stack, new Position());
            this.POS = pos;
        }

        @Override
        public List<? extends ITextProperties> getTooltip() {
            ArrayList<? extends ITextProperties> rtn = new ArrayList<ITextProperties>(super.getTooltip());
            rtn.add(1, (ITextProperties)new StringTextComponent(this.POS.toString()).func_240699_a_(TextFormatting.GRAY));
            return rtn;
        }

        @Override
        public void onClicked(int mx, int my, int button) {
            BlockPosPickerFlowComponent.this.onPicked(this.POS);
        }
    }
}

