/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.util;

import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.core.Size;
import ca.teamdman.sfm.common.flow.core.FlowDataHolder;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.data.FlowData;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ListIterator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public abstract class FlowContainer
extends FlowComponent {
    private final ArrayList<FlowComponent> children = new ArrayList<FlowComponent>(){

        @Override
        public boolean add(FlowComponent o) {
            boolean rtn = super.add(o);
            this.sort(Comparator.comparingInt(FlowComponent::getZIndex));
            return rtn;
        }
    };

    public FlowContainer() {
    }

    public FlowContainer(Position pos) {
        this(pos, new Size(0, 0));
    }

    public FlowContainer(Position pos, Size size) {
        super(pos, size);
    }

    public Optional<FlowComponent> findFirstChild(FlowData data) {
        return this.findFirstChild(data.getId());
    }

    public Optional<FlowComponent> findFirstChild(UUID id) {
        return this.getChildren().stream().filter(c -> c instanceof FlowDataHolder && ((FlowData)((FlowDataHolder)((Object)c)).getData()).getId().equals(id)).findFirst();
    }

    public ArrayList<FlowComponent> getChildren() {
        return this.children;
    }

    public <T> Optional<T> findFirstChild(Class<T> clazz) {
        return this.getChildren().stream().filter(clazz::isInstance).map(clazz::cast).findFirst();
    }

    public void addChild(FlowComponent c) {
        if (c != null) {
            this.children.add(c);
        }
    }

    public boolean removeChild(FlowComponent c) {
        return this.children.remove(c);
    }

    @Override
    public boolean mousePressed(int mx, int my, int button) {
        int pmx = mx - this.getPosition().getX();
        int pmy = my - this.getPosition().getY();
        return this.getEnabledChildrenControllers().anyMatch(c -> c.mousePressed(pmx, pmy, button)) || super.mousePressed(mx, my, button);
    }

    public Stream<FlowComponent> getEnabledChildrenControllers() {
        Stream.Builder<FlowComponent> builder = Stream.builder();
        ListIterator<FlowComponent> iter = this.children.listIterator(this.children.size());
        while (iter.hasPrevious()) {
            builder.add(iter.previous());
        }
        return builder.build().filter(FlowComponent::isEnabled);
    }

    @Override
    public boolean mouseDragged(int mx, int my, int button, int dmx, int dmy) {
        int pmx = mx - this.getPosition().getX();
        int pmy = my - this.getPosition().getY();
        return this.getEnabledChildrenControllers().anyMatch(c -> c.mouseDragged(pmx, pmy, button, dmx, dmy)) || super.mouseDragged(mx, my, button, dmx, dmy);
    }

    @Override
    public boolean mouseReleased(int mx, int my, int button) {
        int pmx = mx - this.getPosition().getX();
        int pmy = my - this.getPosition().getY();
        return this.getEnabledChildrenControllers().anyMatch(c -> c.mouseReleased(pmx, pmy, button)) || super.mouseReleased(mx, my, button);
    }

    @Override
    public String toString() {
        return "FlowContainer{#children=" + this.children.size() + '}';
    }

    @Override
    public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.getPosition().getX(), (double)this.getPosition().getY(), 0.0);
        for (FlowComponent c : this.getChildren()) {
            if (!c.isVisible()) continue;
            c.draw(screen, matrixStack, mx - this.getPosition().getX(), my - this.getPosition().getY(), deltaTime);
        }
        matrixStack.func_227865_b_();
        super.draw(screen, matrixStack, mx, my, deltaTime);
    }

    @Override
    public void drawTooltip(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.getPosition().getX(), (double)this.getPosition().getY(), 0.0);
        for (FlowComponent c : this.getChildren()) {
            if (!c.isVisible()) continue;
            c.drawTooltip(screen, matrixStack, mx - this.getPosition().getX(), my - this.getPosition().getY(), deltaTime);
        }
        matrixStack.func_227865_b_();
        super.drawTooltip(screen, matrixStack, mx, my, deltaTime);
    }

    @Override
    public Stream<? extends FlowComponent> getElementsUnderMouse(int mx, int my) {
        return this.getEnabledChildrenControllers().flatMap(c -> c.getElementsUnderMouse(mx + this.getPosition().getX(), my + this.getPosition().getY()));
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers, int mx, int my) {
        int pmx = mx - this.getPosition().getX();
        int pmy = my - this.getPosition().getY();
        return this.getEnabledChildrenControllers().anyMatch(c -> c.keyPressed(keyCode, scanCode, modifiers, pmx, pmy)) || super.keyPressed(keyCode, scanCode, modifiers, mx, my);
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers, int mx, int my) {
        int pmx = mx - this.getPosition().getX();
        int pmy = my - this.getPosition().getY();
        return this.getEnabledChildrenControllers().anyMatch(c -> c.keyReleased(keyCode, scanCode, modifiers, pmx, pmy) || super.keyReleased(keyCode, scanCode, modifiers, mx, my));
    }

    @Override
    public boolean mouseScrolled(int mx, int my, double scroll) {
        int pmx = mx - this.getPosition().getX();
        int pmy = my - this.getPosition().getY();
        return this.getEnabledChildrenControllers().anyMatch(c -> c.mouseScrolled(pmx, pmy, scroll)) || super.mouseScrolled(mx, my, scroll);
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers, int mx, int my) {
        int pmx = mx - this.getPosition().getX();
        int pmy = my - this.getPosition().getY();
        return this.getEnabledChildrenControllers().anyMatch(c -> c.charTyped(codePoint, modifiers, pmx, pmy)) || super.charTyped(codePoint, modifiers, mx, my);
    }

    @Override
    public void tick() {
        this.getEnabledChildrenControllers().forEach(FlowComponent::tick);
    }

    @Override
    public void drawGhost(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.getPosition().getX(), (double)this.getPosition().getY(), 0.0);
        for (FlowComponent c : this.children) {
            if (!c.isVisible()) continue;
            c.drawGhost(screen, matrixStack, mx - this.getPosition().getX(), my - this.getPosition().getY(), deltaTime);
        }
        matrixStack.func_227865_b_();
    }

    @Override
    public boolean mouseMoved(int mx, int my, boolean consumed) {
        int pmx = mx - this.getPosition().getX();
        int pmy = my - this.getPosition().getY();
        AtomicBoolean cons = new AtomicBoolean(consumed);
        this.getEnabledChildrenControllers().forEach(c -> {
            boolean cons_ = c.mouseMoved(pmx, pmy, cons.get());
            if (!cons.get()) {
                cons.set(cons_);
            }
        });
        return cons.get() || super.mouseMoved(mx, my, false);
    }
}

