/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.util;

import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.Colour3f;
import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowContainer;
import ca.teamdman.sfm.common.flow.core.Position;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.math.MathHelper;

public class FlowDrawer
extends FlowContainer {
    private static final int PADDING_X = 4;
    private static final int PADDING_Y = 4;
    private static final int ITEM_MARGIN_X = 4;
    private static final int ITEM_MARGIN_Y = 4;
    private int maxItemsPerRow;
    private int maxItemsPerColumn;
    private int maxItemWidth;
    private int maxItemHeight;
    private boolean shrinkToFit = true;
    private int scroll = 0;

    public FlowDrawer(Position pos, int maxItemsPerRow, int maxItemsPerColumn) {
        super(pos);
        this.maxItemsPerRow = maxItemsPerRow;
        this.maxItemsPerColumn = maxItemsPerColumn;
    }

    public int getMaxWidth() {
        return (this.maxItemWidth + 4) * this.getMaxItemsPerRow() + 4;
    }

    public int getMaxItemsPerRow() {
        return this.maxItemsPerRow;
    }

    public void setMaxItemsPerRow(int maxItemsPerRow) {
        this.maxItemsPerRow = maxItemsPerRow;
    }

    public void setShrinkToFit(boolean value) {
        this.shrinkToFit = value;
    }

    public void update() {
        this.maxItemWidth = -this.getChildren().stream().mapToInt(c -> -c.getSize().getWidth()).sorted().findFirst().orElse(-32);
        this.maxItemHeight = -this.getChildren().stream().mapToInt(c -> -c.getSize().getHeight()).sorted().findFirst().orElse(-32);
        this.fixScroll();
        this.getSize().setSize(this.shrinkToFit ? (this.maxItemWidth + 4) * this.getItemsPerRow() + 4 : this.getMaxWidth(), this.shrinkToFit ? (this.maxItemHeight + 4) * this.getItemsPerColumn() + 4 : this.getMaxHeight());
        AtomicInteger i = new AtomicInteger();
        this.getChildren().forEach(c -> c.getPosition().setXY(this.getWrappedX(i.get()), this.getWrappedY(i.getAndIncrement()) - this.scroll));
    }

    public void fixScroll() {
        this.scroll = MathHelper.func_76125_a((int)this.scroll, (int)0, (int)Math.max(0, ((int)Math.ceil((float)this.getChildren().size() / (float)this.getItemsPerRow()) - this.getItemsPerColumn()) * (this.maxItemHeight + 4)));
    }

    @Override
    public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        screen.clearRect(matrixStack, this.getPosition().getX(), this.getPosition().getY(), this.getSize().getWidth(), this.getSize().getHeight());
        screen.drawRect(matrixStack, this.getPosition().getX(), this.getPosition().getY(), this.getSize().getWidth(), this.getSize().getHeight(), Colour3f.CONST.PANEL_BACKGROUND_NORMAL);
        screen.beginScissor(matrixStack, this.getPosition().getX() + 2, this.getPosition().getY() + 2, this.getSize().getWidth() - 4, this.getSize().getHeight() - 4);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.getPosition().getX(), (double)this.getPosition().getY(), 0.0);
        for (FlowComponent comp : this.getChildren()) {
            if (!comp.isVisible() || !this.isChildVisible(comp)) continue;
            comp.draw(screen, matrixStack, mx - this.getPosition().getX(), my - this.getPosition().getY(), deltaTime);
        }
        matrixStack.func_227865_b_();
        screen.endScissor();
        screen.drawBorder(matrixStack, this.getPosition().getX(), this.getPosition().getY(), this.getSize().getWidth(), this.getSize().getHeight(), 2, Colour3f.CONST.PANEL_BORDER);
        this.drawTooltip(screen, matrixStack, mx, my, deltaTime);
    }

    @Override
    public boolean mouseScrolled(int mx, int my, double scroll) {
        if (this.isInBounds(mx, my)) {
            if (scroll > 0.0) {
                this.scrollUp();
            } else {
                this.scrollDown();
            }
            return true;
        }
        return false;
    }

    public boolean isChildVisible(FlowComponent comp) {
        return comp.getPosition().getY() > -comp.getSize().getHeight() && comp.getPosition().getY() < this.getMaxHeight();
    }

    public int getMaxHeight() {
        return (this.maxItemHeight + 4) * this.getMaxItemsPerColumn() + 4;
    }

    public int getMaxItemsPerColumn() {
        return this.maxItemsPerColumn;
    }

    public void setMaxItemsPerColumn(int maxItemsPerColumn) {
        this.maxItemsPerColumn = maxItemsPerColumn;
    }

    public void scrollDown() {
        this.scroll += 7;
        this.update();
    }

    public void scrollUp() {
        this.scroll -= 7;
        this.update();
    }

    public int getItemsPerColumn() {
        return MathHelper.func_76125_a((int)(this.getItemRow(this.getChildren().size() - 1) + 1), (int)1, (int)this.getMaxItemsPerColumn());
    }

    public int getItemsPerRow() {
        return MathHelper.func_76125_a((int)this.getChildren().size(), (int)1, (int)this.getMaxItemsPerRow());
    }

    public int getWrappedX(int index) {
        return this.getItemColumn(index) * (this.maxItemWidth + 4) + 2 + 2;
    }

    public int getItemColumn(int index) {
        return index % this.getItemsPerRow();
    }

    public int getItemRow(int index) {
        return (int)Math.floor((float)index / (float)this.getItemsPerRow());
    }

    public int getWrappedY(int index) {
        return this.getItemRow(index) * (this.maxItemHeight + 4) + 2 + 2;
    }
}

