/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.util;

import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.Size;
import ca.teamdman.sfm.client.gui.flow.impl.util.ButtonBackground;
import ca.teamdman.sfm.client.gui.flow.impl.util.ButtonLabel;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowButton;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowSprite;
import ca.teamdman.sfm.common.flow.core.Position;
import com.mojang.blaze3d.matrix.MatrixStack;

public abstract class FlowIconButton
extends FlowButton {
    protected FlowSprite NORMAL_BACKGROUND;
    protected FlowSprite DEPRESSED_BACKGROUND;
    protected FlowSprite LABEL;

    public FlowIconButton(ButtonBackground normalBackground, ButtonBackground depressedBackground, ButtonLabel label, Position pos) {
        super(pos, new Size(normalBackground.WIDTH, normalBackground.HEIGHT));
        this.NORMAL_BACKGROUND = normalBackground.SPRITE;
        this.DEPRESSED_BACKGROUND = depressedBackground.SPRITE;
        this.LABEL = label.SPRITE;
    }

    public FlowIconButton(ButtonLabel type, Position pos) {
        this(ButtonBackground.NORMAL, ButtonBackground.DEPRESSED, type, pos);
    }

    public FlowIconButton(ButtonLabel type) {
        this(type, new Position(0, 0));
    }

    @Override
    public void drawGhost(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        this.NORMAL_BACKGROUND.drawGhostAt(screen, matrixStack, mx, my);
        this.LABEL.drawGhostAt(screen, matrixStack, mx + 4, my + 4);
    }

    protected boolean isDepressed() {
        return this.isHovering() || this.clicking;
    }

    @Override
    public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        if (this.isDepressed()) {
            this.DEPRESSED_BACKGROUND.drawAt(screen, matrixStack, this.getPosition());
        } else {
            this.NORMAL_BACKGROUND.drawAt(screen, matrixStack, this.getPosition());
        }
        this.LABEL.drawAt(screen, matrixStack, this.getPosition().getX() + 4, this.getPosition().getY() + 4);
        super.draw(screen, matrixStack, mx, my, deltaTime);
    }
}

