/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.util;

import ca.teamdman.sfm.client.SearchUtil;
import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.Colour3f;
import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.core.Size;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowContainer;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowDrawer;
import ca.teamdman.sfm.client.gui.flow.impl.util.ItemStackFlowButton;
import ca.teamdman.sfm.client.gui.flow.impl.util.TextAreaFlowComponent;
import ca.teamdman.sfm.common.flow.core.Position;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Comparator;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public abstract class FlowItemStackPicker
extends FlowContainer {
    private final FlowDrawer DRAWER = new FlowDrawer(new Position(0, 20), 5, 7){

        @Override
        public void update() {
            super.update();
            FlowItemStackPicker.this.SEARCH_TEXT_INPUT.getSize().setWidth(this.getSize().getWidth());
        }
    };
    private final TextAreaFlowComponent SEARCH_TEXT_INPUT;
    private SearchUtil.SearchResults searchResults;
    private static final Comparator<FlowComponent> RESULT_COMPARATOR = Comparator.comparing(c -> c instanceof ItemStackFlowButton ? ((ItemStackFlowButton)c).getStack() : ItemStack.field_190927_a, SearchUtil.SEARCH_RESULT_COMPARATOR);

    public FlowItemStackPicker(ManagerFlowController controller, Position pos) {
        super(pos);
        this.DRAWER.setShrinkToFit(false);
        this.SEARCH_TEXT_INPUT = new TextAreaFlowComponent(controller.SCREEN, "", I18n.func_135052_a((String)"gui.sfm.flow.search.placeholder", (Object[])new Object[0]), new Position(0, 0), new Size(100, 20));
        this.addChild(this.DRAWER);
        this.addChild(this.SEARCH_TEXT_INPUT);
        this.SEARCH_TEXT_INPUT.setResponder(text -> {
            if (this.searchResults != null) {
                this.searchResults.cancel();
            }
            this.DRAWER.getChildren().clear();
            this.searchResults = SearchUtil.search(text);
        });
        this.searchResults = SearchUtil.search("");
    }

    @Override
    public void tick() {
        if (this.searchResults == null) {
            return;
        }
        int previous = this.DRAWER.getChildren().size();
        this.searchResults.streamLatestResults().map(x$0 -> new SearchResultStack((ItemStack)x$0)).forEach(this.DRAWER::addChild);
        if (this.DRAWER.getChildren().size() == 0 && this.searchResults.isFinished()) {
            this.DRAWER.addChild(new NoResultsFoundLabelFlowComponent());
        }
        if (this.DRAWER.getChildren().size() != previous) {
            this.DRAWER.getChildren().sort(RESULT_COMPARATOR);
            this.DRAWER.update();
        }
    }

    public abstract void onItemStackChanged(ItemStack var1);

    @Override
    public int getZIndex() {
        return super.getZIndex() + 50;
    }

    private class SearchResultStack
    extends ItemStackFlowButton {
        private final ItemStack stack;

        public SearchResultStack(ItemStack stack) {
            super(stack, new Position());
            this.stack = stack;
        }

        @Override
        public void onClicked(int mx, int my, int button) {
            FlowItemStackPicker.this.setVisible(false);
            FlowItemStackPicker.this.setEnabled(false);
            FlowItemStackPicker.this.onItemStackChanged(this.stack);
        }
    }

    private static class NoResultsFoundLabelFlowComponent
    extends FlowComponent {
        public NoResultsFoundLabelFlowComponent() {
            super(new Position(), ItemStackFlowButton.DEFAULT_SIZE);
        }

        @Override
        public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
            screen.drawString(matrixStack, I18n.func_135052_a((String)"gui.sfm.flow.search.no_results_found", (Object[])new Object[0]), 5, 5, Colour3f.CONST.TEXT_LIGHT);
        }
    }
}

