/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.util;

import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.Colour3f;
import ca.teamdman.sfm.client.gui.flow.core.Size;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowButton;
import ca.teamdman.sfm.common.flow.core.Position;
import com.mojang.blaze3d.matrix.MatrixStack;

public class FlowToggleBox
extends FlowButton {
    private boolean checked = false;

    public FlowToggleBox(Position pos, Size size) {
        super(pos, size);
    }

    public FlowToggleBox(Position pos, Size size, boolean checked) {
        super(pos, size);
        this.checked = checked;
    }

    @Override
    public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        Colour3f colour;
        screen.drawRect(matrixStack, this.getPosition().getX(), this.getPosition().getY(), this.getSize().getWidth(), this.getSize().getHeight(), Colour3f.CONST.CHECKBOX_BACKGROUND);
        int checkMargin = 2;
        Colour3f colour3f = this.isChecked() ? Colour3f.CONST.SELECTED : (colour = this.isHovering() ? Colour3f.CONST.HIGHLIGHT : null);
        if (colour != null) {
            screen.drawRect(matrixStack, this.getPosition().getX() + checkMargin, this.getPosition().getY() + checkMargin, this.getSize().getWidth() - checkMargin * 2, this.getSize().getHeight() - checkMargin * 2, colour);
        }
        super.draw(screen, matrixStack, mx, my, deltaTime);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.onChecked(this.isChecked());
    }

    public void onChecked(boolean checked) {
    }

    @Override
    public void onClicked(int mx, int my, int button) {
        this.setChecked(!this.isChecked());
    }
}

