/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.util;

import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.Colour3f;
import ca.teamdman.sfm.client.gui.flow.core.Size;
import ca.teamdman.sfm.client.gui.flow.impl.util.FlowButton;
import ca.teamdman.sfm.common.flow.core.Position;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextProperties;

public class ItemStackFlowButton
extends FlowButton {
    public static final Size DEFAULT_SIZE = new Size(20, 20).toImmutable();
    private ItemStack STACK;
    private boolean selected;
    private boolean selectable = true;
    private boolean depressed = false;

    public ItemStackFlowButton(ItemStack stack, Position pos) {
        super(pos, DEFAULT_SIZE.copy());
        this.STACK = stack;
    }

    public ItemStack getStack() {
        return this.STACK;
    }

    @Override
    public void onClicked(int mx, int my, int button) {
        this.toggleSelected();
        this.onSelectionChanged();
    }

    @Override
    public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        if (this.isSelected()) {
            this.drawBackground(screen, matrixStack, Colour3f.CONST.SELECTED);
        } else if (this.isHovering()) {
            this.drawBackground(screen, matrixStack, Colour3f.CONST.HIGHLIGHT);
        }
        screen.drawItemStack(matrixStack, this.STACK, this.getPosition().getX() + 2, this.getPosition().getY() + 2);
        super.draw(screen, matrixStack, mx, my, deltaTime);
    }

    @Override
    public List<? extends ITextProperties> getTooltip() {
        return this.getItemStack().func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.ADVANCED);
    }

    public ItemStack getItemStack() {
        return this.STACK;
    }

    public void setItemStack(ItemStack stack) {
        this.STACK = stack;
    }

    protected void drawBackground(BaseScreen screen, MatrixStack matrixStack, Colour3f colour) {
        screen.drawRect(matrixStack, this.getPosition().getX(), this.getPosition().getY(), this.getSize().getWidth(), this.getSize().getHeight(), colour);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean value) {
        if (this.isSelectable()) {
            this.selected = value;
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public void onSelectionChanged() {
    }

    public void toggleSelected() {
        this.setSelected(!this.isSelected());
    }
}

