/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.util;

import ca.teamdman.sfm.client.gui.flow.core.Size;
import ca.teamdman.sfm.client.gui.flow.impl.util.SelectableFlowButton;
import ca.teamdman.sfm.common.flow.core.Position;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class RadioFlowButton
extends SelectableFlowButton {
    private final RadioGroup GROUP;
    private final String HOVER_TEXT;

    public RadioFlowButton(Position pos, Size size, String text, RadioGroup group) {
        this(pos, size, text, null, group);
    }

    public RadioFlowButton(Position pos, Size size, String text, String hoverText, RadioGroup group) {
        super(pos, size, text);
        group.addMember(this);
        this.GROUP = group;
        this.HOVER_TEXT = hoverText;
    }

    public List<ITextProperties> getTooltip() {
        ArrayList<ITextProperties> rtn = new ArrayList<ITextProperties>();
        if (this.HOVER_TEXT != null) {
            rtn.add((ITextProperties)new StringTextComponent(this.HOVER_TEXT));
        }
        return rtn;
    }

    @Override
    public void onSelectionChanged() {
        if (this.isSelected()) {
            this.GROUP.setSelected(this);
        }
    }

    public static class RadioGroup {
        private final HashSet<RadioFlowButton> MEMBERS = new HashSet();

        public void addMember(RadioFlowButton member) {
            this.MEMBERS.add(member);
        }

        public Optional<RadioFlowButton> getSelected() {
            return this.MEMBERS.stream().filter(SelectableFlowButton::isSelected).findFirst();
        }

        public void setSelected(RadioFlowButton member) {
            for (RadioFlowButton button : this.MEMBERS) {
                if (member.equals(button)) {
                    if (member.isSelected()) continue;
                    member.setSelected(true);
                    continue;
                }
                button.setSelected(false);
            }
            this.onSelectionChanged(member);
        }

        public void onSelectionChanged(RadioFlowButton member) {
        }
    }
}

