/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.flow.impl.util;

import ca.teamdman.sfm.client.gui.flow.core.BaseScreen;
import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.core.Size;
import ca.teamdman.sfm.client.gui.flow.impl.util.WidgetPositionDelegate;
import ca.teamdman.sfm.client.gui.flow.impl.util.WidgetSizeDelegate;
import ca.teamdman.sfm.common.flow.core.Position;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.vector.Matrix4f;

public class TextAreaFlowComponent
extends FlowComponent {
    protected final TextFieldWidget delegate;
    private boolean debounce = false;
    private String content;

    public TextAreaFlowComponent(BaseScreen screen, String content, String placeholder, Position pos, Size size) {
        super(new WidgetPositionDelegate(pos), new WidgetSizeDelegate(size));
        this.content = content;
        this.delegate = new PatchedTextFieldWidget(screen.getFontRenderer(), pos.getX(), pos.getY(), size.getWidth(), size.getHeight(), content, placeholder);
        ((WidgetPositionDelegate)this.getPosition()).setWidget((Widget)this.delegate);
        ((WidgetSizeDelegate)this.getSize()).setWidget((Widget)this.delegate);
    }

    public void setContent(String content) {
        this.debounce = true;
        this.delegate.func_146180_a(content);
        this.debounce = false;
    }

    public String getContent() {
        return this.delegate.func_146179_b();
    }

    public void setValidator(Predicate<String> validator) {
        this.delegate.func_200675_a(validator);
    }

    public void setResponder(Consumer<String> responder) {
        this.delegate.func_212954_a(s -> {
            if (!this.debounce) {
                responder.accept((String)s);
            }
        });
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers, int mx, int my) {
        this.delegate.func_231046_a_(keyCode, scanCode, modifiers);
        return this.delegate.func_212955_f();
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers, int mx, int my) {
        this.delegate.func_223281_a_(keyCode, scanCode, modifiers);
        return this.delegate.func_212955_f();
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers, int mx, int my) {
        this.delegate.func_231042_a_(codePoint, modifiers);
        return this.delegate.func_212955_f();
    }

    @Override
    public void tick() {
        this.delegate.func_146178_a();
    }

    @Override
    public boolean mousePressed(int mx, int my, int button) {
        if (this.isInBounds(mx, my) && button == 1) {
            this.clear();
            return true;
        }
        return this.delegate.func_231044_a_((double)mx, (double)my, button);
    }

    public void clear() {
        this.delegate.func_146180_a("");
    }

    @Override
    public boolean mouseDragged(int mx, int my, int button, int dmx, int dmy) {
        return false;
    }

    @Override
    public boolean mouseReleased(int mx, int my, int button) {
        return false;
    }

    @Override
    public void draw(BaseScreen screen, MatrixStack matrixStack, int mx, int my, float deltaTime) {
        screen.clearRect(matrixStack, this.getPosition().getX(), this.getPosition().getY(), this.getSize().getWidth(), this.getSize().getHeight());
        this.delegate.func_230430_a_(matrixStack, mx, my, deltaTime);
    }

    private static class PatchedTextFieldWidget
    extends TextFieldWidget {
        protected final FontRenderer FONT;
        private final String PLACEHOLDER_TEXT;
        private MatrixStack matrixStack;

        public PatchedTextFieldWidget(FontRenderer font, int x, int y, int width, int height, String content, String placeholderContent) {
            super(font, x, y, width, height, null);
            this.func_146180_a(content);
            this.FONT = font;
            this.PLACEHOLDER_TEXT = placeholderContent;
        }

        protected void func_146188_c(int startX, int startY, int endX, int endY) {
            RenderSystem.pushMatrix();
            RenderSystem.multMatrix((Matrix4f)this.matrixStack.func_227866_c_().func_227870_a_());
            super.func_146188_c(startX, startY, endX, endY);
            RenderSystem.popMatrix();
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.matrixStack = matrixStack;
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            if (!this.func_230999_j_() && this.func_146179_b().length() == 0) {
                this.FONT.func_238405_a_(matrixStack, this.PLACEHOLDER_TEXT, (float)(this.field_230690_l_ + 4), (float)this.field_230691_m_ + (float)(this.field_230689_k_ - 8) / 2.0f, 0x707070);
            }
        }
    }
}

