/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.gui.flow.core.ComponentScreen;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.common.config.Config;
import ca.teamdman.sfm.common.container.ManagerContainer;
import ca.teamdman.sfm.common.flow.core.FlowDialog;
import ca.teamdman.sfm.common.flow.core.PositionHolder;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.net.PacketHandler;
import ca.teamdman.sfm.common.net.packet.manager.delete.ManagerDeletePacketC2S;
import ca.teamdman.sfm.common.net.packet.manager.put.ManagerFlowDataPacketC2S;
import ca.teamdman.sfm.common.tile.manager.ManagerTileEntity;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class ManagerScreen
extends ComponentScreen<ManagerFlowController>
implements IHasContainer<ManagerContainer> {
    private final ManagerFlowController CONTROLLER;
    private final ManagerContainer CONTAINER;

    public ManagerScreen(ManagerContainer container, PlayerInventory inv, ITextComponent name) {
        super(name, 512, 256);
        this.CONTAINER = container;
        this.CONTROLLER = new ManagerFlowController(this);
    }

    public void func_231175_as__() {
        this.getFlowDataContainer().notifyGuiClosed();
        super.func_231175_as__();
    }

    public BasicFlowDataContainer getFlowDataContainer() {
        return ((ManagerTileEntity)((Object)this.getContainer().getSource())).getFlowDataContainer();
    }

    public ManagerContainer getContainer() {
        return this.CONTAINER;
    }

    public void reloadFromManagerTileEntity() {
        SFM.LOGGER.debug(SFMUtil.getMarker(((Object)((Object)this)).getClass()), "Loading {} data entries from tile", (Object)((ManagerTileEntity)((Object)this.CONTAINER.getSource())).getFlowDataContainer().size());
        this.getComponent().rebuildChildren();
    }

    @Override
    public ManagerFlowController getComponent() {
        return this.CONTROLLER;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.CONTROLLER.init();
    }

    public <T extends FlowData> void setDialogVisibility(T dialog, boolean visible) {
        HashSet<FlowData> changed = new HashSet<FlowData>();
        if (((FlowDialog)((Object)dialog)).isOpen() != visible) {
            ((FlowDialog)((Object)dialog)).setOpen(visible);
            changed.add(dialog);
        }
        if (visible && !Config.Client.allowMultipleRuleWindows) {
            this.getFlowDataContainer().stream().filter(((Predicate<FlowData>)dialog::equals).negate()).filter(FlowDialog.class::isInstance).map(FlowDialog.class::cast).peek(other -> ((PositionHolder)((Object)dialog)).getPosition().setXY(other.getPosition())).peek(other -> other.setOpen(false)).map(FlowData.class::cast).forEach(changed::add);
        }
        this.CONTROLLER.SCREEN.sendFlowDataToServer(changed);
    }

    public void sendFlowDataToServer(Collection<FlowData> data) {
        if (data.size() > 0) {
            this.sendFlowDataToServer(data.toArray(new FlowData[0]));
        }
    }

    public void sendFlowDataToServer(FlowData ... data) {
        if (data.length > 0) {
            PacketHandler.INSTANCE.sendToServer((Object)new ManagerFlowDataPacketC2S(this.CONTROLLER.SCREEN.getContainer().field_75152_c, ((ManagerTileEntity)((Object)this.CONTROLLER.SCREEN.getContainer().getSource())).func_174877_v(), data));
        }
    }

    public void sendFlowDataDeleteToServer(UUID id) {
        PacketHandler.INSTANCE.sendToServer((Object)new ManagerDeletePacketC2S(this.CONTROLLER.SCREEN.getContainer().field_75152_c, ((ManagerTileEntity)((Object)this.CONTROLLER.SCREEN.getContainer().getSource())).func_174877_v(), id));
    }
}

