/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.block.ICable;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CableNetwork {
    private final World WORLD;
    private final Set<BlockPos> CABLES = new HashSet<BlockPos>();
    private final Map<BlockPos, TileEntity> INVENTORIES = new HashMap<BlockPos, TileEntity>();

    public CableNetwork(World world) {
        this.WORLD = world;
    }

    public void rebuildNetwork(BlockPos pos) {
        this.CABLES.clear();
        this.INVENTORIES.clear();
        this.discoverCables(pos).forEach(this::addCable);
    }

    public Stream<BlockPos> discoverCables(BlockPos startPos) {
        return SFMUtil.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            for (Direction d : Direction.values()) {
                BlockPos offset = current.func_177972_a(d);
                if (!CableNetwork.isValidNetworkMember(this.getWorld(), offset)) continue;
                next.accept(offset);
            }
        }, startPos);
    }

    public boolean addCable(BlockPos pos) {
        boolean isNewMember = this.CABLES.add(pos);
        if (isNewMember) {
            this.rebuildAdjacentInventories(pos);
        }
        return isNewMember;
    }

    public static boolean isValidNetworkMember(World world, BlockPos cablePos) {
        return world.func_180495_p(cablePos).func_177230_c() instanceof ICable;
    }

    public World getWorld() {
        return this.WORLD;
    }

    public void rebuildAdjacentInventories(BlockPos pos) {
        Arrays.stream(Direction.values()).map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).distinct().peek(this.INVENTORIES::remove).filter(this::containsNeighbour).map(arg_0 -> ((World)this.WORLD).func_175625_s(arg_0)).filter(Objects::nonNull).forEach(tile -> this.INVENTORIES.put(tile.func_174877_v(), (TileEntity)tile));
    }

    public boolean containsNeighbour(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.CABLES.contains(pos.func_177972_a(direction))) continue;
            return true;
        }
        return false;
    }

    public Set<BlockPos> split(BlockPos pos) {
        BlockPos start = null;
        for (Direction direction : Direction.values()) {
            BlockPos p2 = pos.func_177972_a(direction);
            if (!this.contains(p2)) continue;
            start = p2;
            break;
        }
        if (start == null) {
            return Collections.emptySet();
        }
        Set retain = SFMUtil.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            for (Direction direction : Direction.values()) {
                BlockPos off = current.func_177972_a(direction);
                if (off.equals((Object)pos) || !this.contains(off)) continue;
                next.accept(off);
            }
        }, start).collect(Collectors.toSet());
        Set<BlockPos> remove = this.CABLES.stream().filter(p -> !retain.contains(p)).collect(Collectors.toSet());
        remove.forEach(this::removeCable);
        remove.remove(pos);
        return remove;
    }

    public boolean contains(BlockPos pos) {
        return this.CABLES.contains(pos);
    }

    public boolean removeCable(BlockPos pos) {
        boolean wasMember = this.CABLES.remove(pos);
        if (wasMember) {
            this.rebuildAdjacentInventories(pos);
        }
        return wasMember;
    }

    public Optional<TileEntity> getInventory(BlockPos pos) {
        return Optional.ofNullable(this.INVENTORIES.get(pos));
    }

    public int size() {
        return this.CABLES.size();
    }

    public void mergeNetwork(CableNetwork other) {
        this.CABLES.addAll(other.CABLES);
        this.INVENTORIES.putAll(other.INVENTORIES);
    }

    public boolean isEmpty() {
        return this.CABLES.isEmpty();
    }

    public Collection<TileEntity> getInventories() {
        return this.INVENTORIES.values();
    }

    public ItemStack getPreview(BlockPos pos) {
        return new ItemStack((IItemProvider)this.WORLD.func_180495_p(pos).func_177230_c().func_199767_j());
    }

    public Set<BlockPos> getCables() {
        return this.CABLES;
    }
}

