/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CableNetworkManager {
    private static final Multimap<RegistryKey<World>, CableNetwork> NETWORKS = ArrayListMultimap.create();

    public static int size() {
        return NETWORKS.size();
    }

    public static void unregister(World world, BlockPos cablePos) {
        Optional<CableNetwork> lookup = NETWORKS.get((Object)world.func_234923_W_()).stream().filter(network -> network.contains(cablePos)).findFirst();
        if (!lookup.isPresent()) {
            return;
        }
        CableNetwork previous = lookup.get();
        if (previous.size() == 1) {
            NETWORKS.remove((Object)world.func_234923_W_(), (Object)previous);
        } else {
            ArrayDeque<BlockPos> split = new ArrayDeque<BlockPos>(previous.split(cablePos));
            while (!split.isEmpty()) {
                BlockPos start = (BlockPos)split.pop();
                CableNetworkManager.getOrRegisterNetwork(world, start).ifPresent(network -> split.removeAll(network.getCables()));
            }
        }
    }

    public static Optional<CableNetwork> getOrRegisterNetwork(TileEntity tile) {
        return CableNetworkManager.getOrRegisterNetwork(tile.func_145831_w(), tile.func_174877_v());
    }

    public static Optional<CableNetwork> getOrRegisterNetwork(World world, BlockPos cablePos) {
        if (!CableNetwork.isValidNetworkMember(world, cablePos)) {
            return Optional.empty();
        }
        Optional<CableNetwork> existing = NETWORKS.get((Object)world.func_234923_W_()).stream().filter(net -> net.getWorld().func_201670_d() == world.func_201670_d()).filter(net -> net.contains(cablePos)).findFirst();
        if (existing.isPresent()) {
            return existing;
        }
        List candidates = NETWORKS.get((Object)world.func_234923_W_()).stream().filter(net -> net.getWorld().func_201670_d() == world.func_201670_d()).filter(net -> net.containsNeighbour(cablePos)).collect(Collectors.toList());
        if (candidates.size() == 0) {
            CableNetwork network = new CableNetwork(world);
            NETWORKS.put((Object)world.func_234923_W_(), (Object)network);
            network.rebuildNetwork(cablePos);
            return Optional.of(network);
        }
        if (candidates.size() == 1) {
            CableNetwork network = (CableNetwork)candidates.get(0);
            network.addCable(cablePos);
            return Optional.of(network);
        }
        CableNetwork network = (CableNetwork)candidates.get(0);
        candidates.listIterator(1).forEachRemaining(other -> {
            network.mergeNetwork((CableNetwork)other);
            NETWORKS.remove((Object)world.func_234923_W_(), other);
        });
        network.addCable(cablePos);
        return Optional.of(network);
    }
}

