/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.config;

import ca.teamdman.sfm.common.config.Config;
import ca.teamdman.sfm.common.config.ConfigHolder;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ConfigHelper {
    public static ModConfig clientConfig;
    public static ModConfig commonConfig;
    public static ModConfig serverConfig;

    public static void setValueAndSave(ModConfig config, String path, Object value) {
        config.getConfigData().set(path, value);
        config.save();
        ConfigHelper.bakeConfig(config);
    }

    public static void setValueAndSave(ModConfig config, ForgeConfigSpec.ConfigValue<?> field, Object value) {
        ConfigHelper.setValueAndSave(config, String.join((CharSequence)".", field.getPath()), value);
    }

    @SubscribeEvent
    public static void onConfig(ModConfig.ModConfigEvent e) {
        ConfigHelper.bakeConfig(e.getConfig());
    }

    public static void bakeConfig(ModConfig config) {
        if (config.getSpec() == ConfigHolder.COMMON_SPEC) {
            ConfigHelper.bakeCommon(config);
        } else if (config.getSpec() == ConfigHolder.SERVER_SPEC) {
            ConfigHelper.bakeServer(config);
        } else if (config.getSpec() == ConfigHolder.CLIENT_SPEC) {
            ConfigHelper.bakeClient(config);
        }
    }

    public static void bakeCommon(ModConfig config) {
        commonConfig = config;
    }

    public static void bakeServer(ModConfig config) {
        serverConfig = config;
    }

    public static void bakeClient(ModConfig config) {
        clientConfig = config;
        Config.Client.allowMultipleRuleWindows = (Boolean)ConfigHolder.CLIENT.allowMultipleRuleWindows.get();
        Config.Client.showRuleDrawerLabels = (Boolean)ConfigHolder.CLIENT.showRuleDrawerLabels.get();
        Config.Client.alwaysSnapMovementToGrid = (Boolean)ConfigHolder.CLIENT.alwaysSnapMovementToGrid.get();
        Config.Client.allowElementsOutOfBounds = (Boolean)ConfigHolder.CLIENT.allowElementsOutOfBounds.get();
        Config.Client.enableRegexSearch = (Boolean)ConfigHolder.CLIENT.enableRegexSearch.get();
        Config.Client.hideManagerInstructions = (Boolean)ConfigHolder.CLIENT.hideManagerInstructions.get();
        Config.Client.preventClosingManagerWithInventoryButton = (Boolean)ConfigHolder.CLIENT.preventClosingManagerWithInventoryButton.get();
        Config.Client.enableDebugMode = (Boolean)ConfigHolder.CLIENT.enableDebugMode.get();
    }
}

