/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.container;

import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.container.BaseContainer;
import ca.teamdman.sfm.common.registrar.ContainerRegistrar;
import ca.teamdman.sfm.common.tile.manager.ManagerTileEntity;
import ca.teamdman.sfm.common.util.SFMUtil;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class ManagerContainer
extends BaseContainer<ManagerTileEntity> {
    public ManagerContainer(int windowId, ManagerTileEntity tile, boolean isRemote) {
        super((ContainerType)ContainerRegistrar.MANAGER.get(), windowId, tile, isRemote);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ManagerContainer create(int windowId, PlayerInventory inv, PacketBuffer data) {
        return SFMUtil.getClientTile(IWorldPosCallable.func_221488_a((World)inv.field_70458_d.field_70170_p, (BlockPos)data.func_179259_c()), ManagerTileEntity.class).map(tile -> {
            CableNetworkManager.getOrRegisterNetwork(tile.func_145831_w(), tile.func_174877_v()).ifPresent(network -> network.rebuildNetwork(tile.func_174877_v()));
            ManagerContainer container = new ManagerContainer(windowId, (ManagerTileEntity)((Object)tile), true);
            container.readData(data);
            return container;
        }).orElse(null);
    }

    public static void openGui(ServerPlayerEntity player, ManagerTileEntity tile) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)tile, data -> ManagerContainer.writeData(tile, data));
    }

    private void readData(PacketBuffer data) {
        ((ManagerTileEntity)((Object)this.getSource())).deserializeNBT(data.func_150793_b());
    }

    private static void writeData(ManagerTileEntity tile, PacketBuffer data) {
        data.func_179255_a(tile.func_174877_v());
        data.func_150786_a(tile.serializeNBT());
    }

    @SubscribeEvent
    public void onContainerOpen(PlayerContainerEvent.Open e) {
        if (!this.IS_REMOTE) {
            ((ManagerTileEntity)((Object)this.getSource())).addContainerListener((ServerPlayerEntity)e.getPlayer(), e.getContainer().field_75152_c);
        }
    }

    @SubscribeEvent
    public void onContainerClose(PlayerContainerEvent.Close e) {
        if (!this.IS_REMOTE) {
            ((ManagerTileEntity)((Object)this.getSource())).removeContainerListener((ServerPlayerEntity)e.getPlayer());
        }
    }
}

