/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.core;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class Position
implements INBTSerializable<CompoundNBT> {
    public static final Position ZERO = new Position(0, 0){

        @Override
        public void setX(int x) {
            throw new RuntimeException("The ZERO position instance can not be modified.");
        }

        @Override
        public void setY(int y) {
            throw new RuntimeException("This ZERO position instance can not be modified.");
        }
    };
    private int x;
    private int y;

    public Position(Position copy) {
        this(copy.getX(), copy.getY());
    }

    public Position(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Position() {
        this(0, 0);
    }

    public Position(CompoundNBT tag) {
        this(0, 0);
        this.deserializeNBT(tag);
    }

    public static Position fromLong(long packed) {
        return new Position((int)(packed >> 32), (int)packed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position position = (Position)o;
        return this.getX() == position.getX() && this.getY() == position.getY();
    }

    public boolean equals(int x, int y) {
        return x == this.x && y == this.y;
    }

    public Position withConstantOffset(final int x, final int y) {
        return new Position(){

            @Override
            public int getX() {
                return Position.this.getX() + x;
            }

            @Override
            public int getY() {
                return Position.this.getY() + y;
            }
        };
    }

    public Position withConstantOffset(final Position other) {
        return new Position(){

            @Override
            public int getX() {
                return Position.this.getX() + other.getX();
            }

            @Override
            public int getY() {
                return Position.this.getY() + other.getY();
            }
        };
    }

    public Position withConstantOffset(final Supplier<Integer> x, final Supplier<Integer> y) {
        return new Position(){

            @Override
            public int getY() {
                return Position.this.getY() + (Integer)y.get();
            }

            @Override
            public int getX() {
                return Position.this.getX() + (Integer)x.get();
            }
        };
    }

    public int hashCode() {
        return Objects.hash(this.getX(), this.getY());
    }

    public long toLong() {
        return (long)this.getX() << 32 | (long)this.getY() & 0xFFFFFFFFL;
    }

    public Position copy() {
        return new Position(this);
    }

    public Position withOffset(int x, int y) {
        return new Position(this.getX() + x, this.getY() + y);
    }

    public Position withOffset(Position other) {
        return new Position(this.getX() + other.getX(), this.getY() + other.getY());
    }

    public Position subtract(Position pos) {
        return new Position(this.getX() - pos.getX(), this.getY() - pos.getY());
    }

    public Position add(Position pos) {
        return new Position(this.getX() + pos.getX(), this.getY() + pos.getY());
    }

    public void addXY(Position pos) {
        this.addXY(pos.getX(), pos.getY());
    }

    public void addXY(int x, int y) {
        this.setXY(this.getX() + x, this.getY() + y);
    }

    public Position multiply(int val) {
        return new Position(this.getX() * val, this.getY() * val);
    }

    public int dot(Position pos) {
        return this.getX() * pos.getX() + this.getY() * pos.getY();
    }

    public int magnitudeSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY();
    }

    public void setXY(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public void setXY(Position pos) {
        this.setXY(pos.x, pos.y);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("x", this.getX());
        tag.func_74768_a("y", this.getY());
        return tag;
    }

    public String toString() {
        return "Position[" + this.getX() + ", " + this.getY() + "]";
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setXY(nbt.func_74762_e("x"), nbt.func_74762_e("y"));
    }
}

