/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.ConditionLineNodeFlowComponent;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.core.PositionHolder;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.data.ItemConditionRuleFlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.registrar.FlowDataSerializerRegistrar;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.Observable;
import java.util.Observer;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ConditionLineNodeFlowData
extends FlowData
implements Observer,
PositionHolder {
    public Position position;
    public ItemConditionRuleFlowData.Result responsibility;

    public ConditionLineNodeFlowData(ItemConditionRuleFlowData.Result resp) {
        this(UUID.randomUUID(), new Position(), resp);
    }

    public ConditionLineNodeFlowData(ConditionLineNodeFlowData other) {
        this(UUID.randomUUID(), other.position.copy(), other.responsibility);
    }

    public ConditionLineNodeFlowData(UUID uuid, Position position, ItemConditionRuleFlowData.Result resp) {
        super(uuid);
        this.position = position;
        this.responsibility = resp;
    }

    @Override
    public void addToDataContainer(BasicFlowDataContainer container) {
        super.addToDataContainer(container);
        container.addObserver(this);
    }

    @Override
    public ConditionLineNodeFlowData duplicate(BasicFlowDataContainer container, Consumer<FlowData> dependencyTracker) {
        return new ConditionLineNodeFlowData(this);
    }

    @Override
    public boolean isValidRelationshipTarget() {
        return true;
    }

    @Override
    public FlowComponent createController(FlowComponent parent) {
        if (!(parent instanceof ManagerFlowController)) {
            return null;
        }
        return new ConditionLineNodeFlowComponent((ManagerFlowController)parent, this);
    }

    public FlowDataSerializer<ConditionLineNodeFlowData> getSerializer() {
        return FlowDataSerializerRegistrar.FlowDataSerializers.CONDITION_LINE_NODE;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof BasicFlowDataContainer.FlowDataContainerChange && o instanceof BasicFlowDataContainer) {
            BasicFlowDataContainer.FlowDataContainerChange change = (BasicFlowDataContainer.FlowDataContainerChange)arg;
            BasicFlowDataContainer container = (BasicFlowDataContainer)o;
            if (change.CHANGE == BasicFlowDataContainer.FlowDataContainerChange.ChangeType.REMOVED && !container.getAncestors(this.getId(), false).findAny().isPresent()) {
                container.remove(this.getId());
                o.deleteObserver(this);
            }
        }
    }

    public static class Serializer
    extends FlowDataSerializer<ConditionLineNodeFlowData> {
        public Serializer(ResourceLocation key) {
            super(key);
        }

        @Override
        public ConditionLineNodeFlowData fromNBT(CompoundNBT tag) {
            return new ConditionLineNodeFlowData(Serializer.getUUID(tag), new Position(tag.func_74775_l("pos")), ItemConditionRuleFlowData.Result.valueOf(tag.func_74779_i("resp")));
        }

        @Override
        public CompoundNBT toNBT(ConditionLineNodeFlowData data) {
            CompoundNBT tag = super.toNBT(data);
            tag.func_218657_a("pos", (INBT)data.position.serializeNBT());
            tag.func_74778_a("resp", data.responsibility.name());
            return tag;
        }

        @Override
        public ConditionLineNodeFlowData fromBuffer(PacketBuffer buf) {
            return new ConditionLineNodeFlowData(SFMUtil.readUUID(buf), Position.fromLong(buf.readLong()), ItemConditionRuleFlowData.Result.valueOf(buf.func_150789_c(12)));
        }

        @Override
        public void toBuffer(ConditionLineNodeFlowData data, PacketBuffer buf) {
            SFMUtil.writeUUID(data.getId(), buf);
            buf.writeLong(data.position.toLong());
            buf.func_211400_a(data.responsibility.name(), 12);
        }
    }
}

