/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.FlowCursor;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.core.PositionHolder;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.registrar.FlowDataSerializerRegistrar;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class CursorFlowData
extends FlowData
implements PositionHolder {
    public String playerName;
    public Position position;

    public CursorFlowData(CursorFlowData other) {
        this(UUID.randomUUID(), other.playerName, other.position.copy());
    }

    public CursorFlowData(UUID uuid, String playerName, Position position) {
        super(uuid);
        this.playerName = playerName;
        this.position = position;
    }

    @Override
    public FlowData duplicate(BasicFlowDataContainer container, Consumer<FlowData> dependencyTracker) {
        return new CursorFlowData(this);
    }

    @Override
    @Nullable
    public FlowComponent createController(FlowComponent parent) {
        if (parent instanceof ManagerFlowController) {
            return new FlowCursor((ManagerFlowController)parent, this);
        }
        return null;
    }

    public FlowDataSerializer<CursorFlowData> getSerializer() {
        return FlowDataSerializerRegistrar.FlowDataSerializers.CURSOR;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    public static class Serializer
    extends FlowDataSerializer<CursorFlowData> {
        public Serializer(ResourceLocation key) {
            super(key);
        }

        @Override
        public CursorFlowData fromNBT(CompoundNBT tag) {
            return new CursorFlowData(Serializer.getUUID(tag), tag.func_74779_i("player"), new Position(tag.func_74775_l("position")));
        }

        @Override
        public CompoundNBT toNBT(CursorFlowData data) {
            CompoundNBT tag = super.toNBT(data);
            tag.func_74778_a("player", data.playerName);
            tag.func_218657_a("position", (INBT)data.position.serializeNBT());
            return tag;
        }

        @Override
        public CursorFlowData fromBuffer(PacketBuffer buf) {
            return new CursorFlowData(SFMUtil.readUUID(buf), buf.func_150789_c(64), Position.fromLong(buf.readLong()));
        }

        @Override
        public void toBuffer(CursorFlowData data, PacketBuffer buf) {
            SFMUtil.writeUUID(data.getId(), buf);
            buf.func_211400_a(data.playerName, 64);
            buf.writeLong(data.position.toLong());
        }
    }
}

