/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.data.RelationshipFlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.tile.manager.ExecutionStep;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class FlowData {
    private final UUID uuid;

    public FlowData(UUID uuid) {
        this.uuid = uuid;
    }

    public FlowData() {
        this.uuid = UUID.randomUUID();
    }

    public void addToDataContainer(BasicFlowDataContainer container) {
        container.put(this);
    }

    public void removeFromDataContainer(BasicFlowDataContainer container) {
        container.remove(this.getId());
    }

    public UUID getId() {
        return this.uuid;
    }

    public void execute(ExecutionStep step) {
    }

    public abstract FlowData duplicate(BasicFlowDataContainer var1, Consumer<FlowData> var2);

    public boolean isValidRelationshipTarget() {
        return false;
    }

    public Stream<? extends FlowData> getNextUsingRelationships(BasicFlowDataContainer container) {
        return container.get(RelationshipFlowData.class).filter(rel -> rel.from.equals(this.getId())).map(rel -> rel.to).map(container::get).filter(Optional::isPresent).map(Optional::get);
    }

    public String toString() {
        return this.getId().toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public abstract FlowComponent createController(FlowComponent var1);

    public Set<Class<?>> getDependencies() {
        return Collections.emptySet();
    }

    public CompoundNBT serialize() {
        FlowDataSerializer<?> serializer = this.getSerializer();
        CompoundNBT tag = serializer.toNBT(this);
        return tag;
    }

    public abstract FlowDataSerializer<?> getSerializer();
}

