/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class FlowDataSerializer<T extends FlowData>
extends ForgeRegistryEntry<FlowDataSerializer<?>> {
    public static final String NBT_SERIALIZER_REGISTRY_NAME_KEY = "__type";
    public static final String NBT_SERIALIZER_SCHEMA_VERSION_KEY = "__version";
    public static final String NBT_SERIALIZER_UUID_KEY = "__uuid";
    private static IForgeRegistry cached = null;

    public FlowDataSerializer(ResourceLocation registryName) {
        this.setRegistryName(registryName);
    }

    public static UUID getUUID(CompoundNBT tag) {
        if (tag.func_150297_b(NBT_SERIALIZER_UUID_KEY, 8)) {
            return UUID.fromString(tag.func_74779_i(NBT_SERIALIZER_UUID_KEY));
        }
        throw new IllegalArgumentException("tag doesn't contain a uuid");
    }

    public static Optional<FlowData> deserialize(CompoundNBT tag) {
        Optional<FlowDataSerializer<?>> serializer = FlowDataSerializer.getSerializer(tag);
        if (!serializer.isPresent()) {
            SFM.LOGGER.warn(SFMUtil.getMarker(FlowDataSerializer.class), "Could not find serializer for tag {}", (Object)tag);
            return Optional.empty();
        }
        try {
            Object data = serializer.get().fromPossiblyOutdatedNBT(tag);
            return Optional.of(data);
        }
        catch (Exception e) {
            SFM.LOGGER.error(SFMUtil.getMarker(FlowDataSerializer.class), "Error deserializing flow data from {}", (Object)tag, (Object)e);
            return Optional.empty();
        }
    }

    public static Optional<FlowDataSerializer<?>> getSerializer(CompoundNBT tag) {
        if (!tag.func_150297_b(NBT_SERIALIZER_REGISTRY_NAME_KEY, 8)) {
            return Optional.empty();
        }
        return FlowDataSerializer.getSerializer(tag.func_74779_i(NBT_SERIALIZER_REGISTRY_NAME_KEY));
    }

    public T fromPossiblyOutdatedNBT(CompoundNBT tag) {
        if (FlowDataSerializer.getVersion(tag = this.getWithLatestSchema(tag, FlowDataSerializer.getVersion(tag))) != this.getVersion()) {
            throw new IllegalArgumentException("tag schema not latest after updating");
        }
        return this.fromNBT(tag);
    }

    public static Optional<FlowDataSerializer<?>> getSerializer(String id) {
        return FlowDataSerializer.getSerializer(ResourceLocation.func_208304_a((String)id));
    }

    public CompoundNBT getWithLatestSchema(CompoundNBT tag, int currentVersion) {
        return tag;
    }

    public static int getVersion(CompoundNBT tag) {
        if (tag.func_150297_b(NBT_SERIALIZER_SCHEMA_VERSION_KEY, 3)) {
            return tag.func_74762_e(NBT_SERIALIZER_SCHEMA_VERSION_KEY);
        }
        throw new IllegalArgumentException("tag doesn't contain a schema version");
    }

    public int getVersion() {
        return 1;
    }

    public abstract T fromNBT(CompoundNBT var1);

    public static Optional<FlowDataSerializer<?>> getSerializer(ResourceLocation id) {
        if (cached == null) {
            cached = GameRegistry.findRegistry(FlowDataSerializer.class);
        }
        return Optional.ofNullable(cached).map(r -> (FlowDataSerializer)r.getValue(id));
    }

    public CompoundNBT toNBT(T data) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a(NBT_SERIALIZER_REGISTRY_NAME_KEY, this.getRegistryName().toString());
        FlowDataSerializer.setVersion(tag, this.getVersion());
        tag.func_74778_a(NBT_SERIALIZER_UUID_KEY, ((FlowData)data).getId().toString());
        return tag;
    }

    public static void setVersion(CompoundNBT tag, int version) {
        tag.func_74768_a(NBT_SERIALIZER_SCHEMA_VERSION_KEY, version);
    }

    public abstract T fromBuffer(PacketBuffer var1);

    public abstract void toBuffer(T var1, PacketBuffer var2);
}

