/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.ItemConditionFlowButton;
import ca.teamdman.sfm.client.gui.flow.impl.util.ButtonBackground;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.flow.core.ItemMatcher;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.core.PositionHolder;
import ca.teamdman.sfm.common.flow.data.ConditionLineNodeFlowData;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.data.ItemConditionRuleFlowData;
import ca.teamdman.sfm.common.flow.data.RelationshipFlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.flow.holder.FlowDataRemovedObserver;
import ca.teamdman.sfm.common.registrar.FlowDataSerializerRegistrar;
import ca.teamdman.sfm.common.tile.manager.ExecutionStep;
import ca.teamdman.sfm.common.util.SFMUtil;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;

public class ItemConditionFlowData
extends FlowData
implements Observer,
PositionHolder {
    private final FlowDataRemovedObserver OBSERVER;
    public Position position;
    public UUID rule;
    private transient ItemConditionRuleFlowData.Result result;

    public ItemConditionFlowData(ItemConditionFlowData other) {
        this(UUID.randomUUID(), other.position.copy(), other.rule);
    }

    public ItemConditionFlowData(UUID uuid, Position position, UUID rule) {
        super(uuid);
        this.position = position;
        this.rule = rule;
        this.OBSERVER = new FlowDataRemovedObserver(this, data -> data.getId().equals(rule), c -> c.remove(this.getId()));
    }

    @Override
    public void addToDataContainer(BasicFlowDataContainer container) {
        super.addToDataContainer(container);
        container.addObserver(this);
    }

    @Override
    public void removeFromDataContainer(BasicFlowDataContainer container) {
        super.removeFromDataContainer(container);
        container.get(this.rule).ifPresent(data -> data.removeFromDataContainer(container));
    }

    @Override
    public void execute(ExecutionStep step) {
        BasicFlowDataContainer container = step.TILE.getFlowDataContainer();
        Optional<CableNetwork> net = CableNetworkManager.getOrRegisterNetwork(step.TILE);
        if (!net.isPresent()) {
            return;
        }
        Optional<ItemConditionRuleFlowData> rule = container.get(this.rule, ItemConditionRuleFlowData.class);
        if (!rule.isPresent()) {
            return;
        }
        this.result = this.isSatisfied(step, container, net.get(), rule.get());
    }

    @Override
    public ItemConditionFlowData duplicate(BasicFlowDataContainer container, Consumer<FlowData> dependencyTracker) {
        final ItemConditionFlowData dupe = new ItemConditionFlowData(this);
        container.get(dupe.rule, ItemConditionRuleFlowData.class).ifPresent(data -> {
            FlowData newRule = data.duplicate(container, (Consumer)dependencyTracker);
            dependencyTracker.accept(newRule);
            dupe.rule = newRule.getId();
        });
        final ConditionLineNodeFlowData acceptedNode = new ConditionLineNodeFlowData(ItemConditionRuleFlowData.Result.ACCEPTED);
        dependencyTracker.accept(acceptedNode);
        final ConditionLineNodeFlowData rejectedNode = new ConditionLineNodeFlowData(ItemConditionRuleFlowData.Result.REJECTED);
        dependencyTracker.accept(rejectedNode);
        RelationshipFlowData acceptedRel = new RelationshipFlowData(dupe.getId(), acceptedNode.getId());
        dependencyTracker.accept(acceptedRel);
        RelationshipFlowData rejectedRel = new RelationshipFlowData(dupe.getId(), rejectedNode.getId());
        dependencyTracker.accept(rejectedRel);
        dupe.position = new Position(){

            @Override
            public void setXY(int x, int y) {
                super.setXY(x, y);
                acceptedNode.position.setXY(dupe.getPosition().withOffset(-ButtonBackground.LINE_NODE.WIDTH, ButtonBackground.NORMAL.HEIGHT));
                rejectedNode.position.setXY(dupe.getPosition().withOffset(ButtonBackground.NORMAL.WIDTH, ButtonBackground.NORMAL.HEIGHT));
            }
        };
        return dupe;
    }

    @Override
    public boolean isValidRelationshipTarget() {
        return true;
    }

    public Stream<ConditionLineNodeFlowData> getNextUsingRelationships(BasicFlowDataContainer container) {
        return super.getNextUsingRelationships(container).filter(ConditionLineNodeFlowData.class::isInstance).map(ConditionLineNodeFlowData.class::cast).filter(node -> node.responsibility == this.result);
    }

    @Override
    public FlowComponent createController(FlowComponent parent) {
        if (parent instanceof ManagerFlowController) {
            return new ItemConditionFlowButton((ManagerFlowController)parent, this, ((ManagerFlowController)parent).SCREEN.getFlowDataContainer().get(this.rule, ItemConditionRuleFlowData.class).orElseGet(ItemConditionRuleFlowData::new));
        }
        return null;
    }

    @Override
    public Set<Class<?>> getDependencies() {
        return ImmutableSet.of(ItemConditionRuleFlowData.class);
    }

    public FlowDataSerializer<ItemConditionFlowData> getSerializer() {
        return FlowDataSerializerRegistrar.FlowDataSerializers.ITEM_CONDITION;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    private ItemConditionRuleFlowData.Result isSatisfied(ExecutionStep step, BasicFlowDataContainer container, CableNetwork network, ItemConditionRuleFlowData rule) {
        List itemMatchers = rule.itemMatcherIds.stream().map(container::get).filter(Optional::isPresent).map(Optional::get).filter(ItemMatcher.class::isInstance).map(ItemMatcher.class::cast).collect(Collectors.toList());
        List<IItemHandler> handlers = rule.getItemHandlers(container, network);
        if (itemMatchers.size() == 0 || handlers.size() == 0) {
            return ItemConditionRuleFlowData.Result.ACCEPTED;
        }
        for (IItemHandler handler : handlers) {
            HashSet unsatisfied = new HashSet(itemMatchers);
            for (int slot : rule.slots.getSlots(handler.getSlots()).toArray()) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (stack.func_190926_b()) continue;
                boolean satisfiedAny = unsatisfied.removeIf(matcher -> matcher.matches(stack));
                if (satisfiedAny && rule.itemMode == ItemConditionRuleFlowData.ItemMode.MATCH_ANY || unsatisfied.size() == 0) break;
                if (rule.tileMode != ItemConditionRuleFlowData.TileMode.MATCH_ANY || !satisfiedAny) continue;
                return ItemConditionRuleFlowData.Result.ACCEPTED;
            }
            if (unsatisfied.size() == itemMatchers.size() && rule.itemMode == ItemConditionRuleFlowData.ItemMode.MATCH_ANY) {
                return ItemConditionRuleFlowData.Result.REJECTED;
            }
            if (rule.itemMode != ItemConditionRuleFlowData.ItemMode.MATCH_ALL || unsatisfied.size() <= 0) continue;
            return ItemConditionRuleFlowData.Result.REJECTED;
        }
        return ItemConditionRuleFlowData.Result.ACCEPTED;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.OBSERVER.update(o, arg);
    }

    public static class Serializer
    extends FlowDataSerializer<ItemConditionFlowData> {
        public Serializer(ResourceLocation key) {
            super(key);
        }

        @Override
        public ItemConditionFlowData fromNBT(CompoundNBT tag) {
            return new ItemConditionFlowData(Serializer.getUUID(tag), new Position(tag.func_74775_l("pos")), UUID.fromString(tag.func_74779_i("tileEntityRule")));
        }

        @Override
        public CompoundNBT toNBT(ItemConditionFlowData data) {
            CompoundNBT tag = super.toNBT(data);
            tag.func_218657_a("pos", (INBT)data.position.serializeNBT());
            tag.func_74778_a("tileEntityRule", data.rule.toString());
            return tag;
        }

        @Override
        public ItemConditionFlowData fromBuffer(PacketBuffer buf) {
            return new ItemConditionFlowData(SFMUtil.readUUID(buf), Position.fromLong(buf.readLong()), SFMUtil.readUUID(buf));
        }

        @Override
        public void toBuffer(ItemConditionFlowData data, PacketBuffer buf) {
            SFMUtil.writeUUID(data.getId(), buf);
            buf.writeLong(data.position.toLong());
            SFMUtil.writeUUID(data.rule, buf);
        }
    }
}

