/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.itemconditionrule.ItemConditionRuleFlowComponent;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.flow.core.FlowDialog;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.core.PositionHolder;
import ca.teamdman.sfm.common.flow.core.TileMatcher;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.flow.holder.FlowDataRemovedObserver;
import ca.teamdman.sfm.common.registrar.FlowDataSerializerRegistrar;
import ca.teamdman.sfm.common.util.EnumSetSerializationHelper;
import ca.teamdman.sfm.common.util.SFMUtil;
import ca.teamdman.sfm.common.util.SlotsRule;
import ca.teamdman.sfm.common.util.UUIDList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemConditionRuleFlowData
extends FlowData
implements PositionHolder,
FlowDialog {
    public static final int MAX_NAME_LENGTH = 256;
    private final FlowDataRemovedObserver DATA_REMOVED_OBSERVER;
    public String name;
    public ItemStack icon;
    public Position position;
    public UUIDList itemMatcherIds;
    public UUIDList tileMatcherIds;
    public ItemMode itemMode;
    public TileMode tileMode;
    public EnumSet<Direction> faces;
    public SlotsRule slots;
    public boolean open;

    public ItemConditionRuleFlowData() {
        this(UUID.randomUUID(), I18n.func_135052_a((String)"gui.sfm.flow.placeholder.default_rule_name", (Object[])new Object[0]), ItemStack.field_190927_a, new Position(0, 0), Collections.emptyList(), Collections.emptyList(), EnumSet.allOf(Direction.class), new SlotsRule(""), ItemMode.MATCH_ALL, TileMode.MATCH_ALL, false);
    }

    public ItemConditionRuleFlowData(UUID uuid, String name, ItemStack icon, Position position, Collection<UUID> itemMatcherIds, Collection<UUID> tileMatcherIds, EnumSet<Direction> faces, SlotsRule slots, ItemMode itemMode, TileMode tileMode, boolean open) {
        super(uuid);
        this.name = name;
        this.icon = icon;
        this.position = position;
        this.itemMatcherIds = new UUIDList((Collection<? extends UUID>)itemMatcherIds);
        this.faces = faces;
        this.slots = slots;
        this.open = open;
        this.DATA_REMOVED_OBSERVER = new FlowDataRemovedObserver(this, data -> this.itemMatcherIds.remove(data.getId()) || this.tileMatcherIds.remove(data.getId()));
        this.tileMatcherIds = new UUIDList((Collection<? extends UUID>)tileMatcherIds);
        this.itemMode = itemMode;
        this.tileMode = tileMode;
    }

    public ItemConditionRuleFlowData(ItemConditionRuleFlowData other) {
        this(UUID.randomUUID(), other.name, other.icon.func_77946_l(), other.position.copy(), new UUIDList(other.itemMatcherIds), new UUIDList(other.tileMatcherIds), EnumSet.copyOf(other.faces), other.slots.copy(), other.itemMode, other.tileMode, other.open);
    }

    public List<IItemHandler> getItemHandlers(BasicFlowDataContainer container, CableNetwork network) {
        return this.getTiles(container, network).flatMap(tile -> this.faces.stream().map(face -> tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face))).filter(LazyOptional::isPresent).map(LazyOptional::resolve).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Stream<TileEntity> getTiles(BasicFlowDataContainer container, CableNetwork network) {
        List matchers = this.tileMatcherIds.stream().map(id -> container.get((UUID)id, TileMatcher.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        Predicate<TileEntity> matches = tile -> matchers.stream().anyMatch(m -> m.matches((TileEntity)tile));
        return network.getInventories().stream().filter(matches);
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void addToDataContainer(BasicFlowDataContainer container) {
        super.addToDataContainer(container);
        container.addObserver(this.DATA_REMOVED_OBSERVER);
    }

    @Override
    public void removeFromDataContainer(BasicFlowDataContainer container) {
        super.removeFromDataContainer(container);
        Stream.concat(this.itemMatcherIds.stream(), this.tileMatcherIds.stream()).map(container::get).filter(Optional::isPresent).map(Optional::get).forEach(data -> data.removeFromDataContainer(container));
    }

    @Override
    public ItemConditionRuleFlowData duplicate(BasicFlowDataContainer container, Consumer<FlowData> dependencyTracker) {
        return new ItemConditionRuleFlowData(this);
    }

    @Override
    @Nullable
    public FlowComponent createController(FlowComponent parent) {
        if (!(parent instanceof ManagerFlowController)) {
            return null;
        }
        return new ItemConditionRuleFlowComponent((ManagerFlowController)parent, this);
    }

    @Override
    public FlowDataSerializer<?> getSerializer() {
        return FlowDataSerializerRegistrar.FlowDataSerializers.ITEM_CONDITION_RULE;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void setOpen(boolean value) {
        this.open = value;
    }

    public static class Serializer
    extends FlowDataSerializer<ItemConditionRuleFlowData> {
        public Serializer(ResourceLocation registryName) {
            super(registryName);
        }

        @Override
        public ItemConditionRuleFlowData fromNBT(CompoundNBT tag) {
            return new ItemConditionRuleFlowData(Serializer.getUUID(tag), tag.func_74779_i("name"), ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("icon")), new Position(tag.func_74775_l("pos")), new UUIDList(tag, "itemMatchers"), new UUIDList(tag, "tileMatchers"), EnumSetSerializationHelper.deserialize(tag, "faces", Direction::valueOf), new SlotsRule(tag.func_74779_i("slots")), ItemMode.valueOf(tag.func_74779_i("itemMode")), TileMode.valueOf(tag.func_74779_i("tileMode")), tag.func_74767_n("open"));
        }

        @Override
        public CompoundNBT toNBT(ItemConditionRuleFlowData data) {
            CompoundNBT tag = super.toNBT(data);
            tag.func_74778_a("name", data.name);
            tag.func_218657_a("icon", (INBT)data.icon.serializeNBT());
            tag.func_218657_a("pos", (INBT)data.position.serializeNBT());
            tag.func_218657_a("itemMatchers", (INBT)data.itemMatcherIds.serialize());
            tag.func_218657_a("tileMatchers", (INBT)data.tileMatcherIds.serialize());
            tag.func_218657_a("faces", (INBT)EnumSetSerializationHelper.serialize(data.faces));
            tag.func_74778_a("slots", data.slots.getDefinition());
            tag.func_74778_a("itemMode", data.itemMode.name());
            tag.func_74778_a("tileMode", data.tileMode.name());
            tag.func_74757_a("open", data.open);
            return tag;
        }

        @Override
        public ItemConditionRuleFlowData fromBuffer(PacketBuffer buf) {
            return new ItemConditionRuleFlowData(SFMUtil.readUUID(buf), buf.func_150789_c(256), buf.func_150791_c(), Position.fromLong(buf.readLong()), new UUIDList(buf), new UUIDList(buf), EnumSetSerializationHelper.deserialize(buf, Direction::valueOf, Direction.class), new SlotsRule(buf.func_150789_c(32)), ItemMode.valueOf(buf.func_150789_c(16)), TileMode.valueOf(buf.func_150789_c(16)), buf.readBoolean());
        }

        @Override
        public void toBuffer(ItemConditionRuleFlowData data, PacketBuffer buf) {
            SFMUtil.writeUUID(data.getId(), buf);
            buf.func_211400_a(data.name, 256);
            buf.func_150788_a(data.icon);
            buf.writeLong(data.position.toLong());
            data.itemMatcherIds.serialize(buf);
            data.tileMatcherIds.serialize(buf);
            EnumSetSerializationHelper.serialize(data.faces, buf);
            buf.func_211400_a(data.slots.getDefinition(), 32);
            buf.func_211400_a(data.itemMode.name(), 16);
            buf.func_211400_a(data.tileMode.name(), 16);
            buf.writeBoolean(data.open);
        }
    }

    public static enum Result {
        ACCEPTED("gui.sfm.flow.tooltip.condition_accepted", true),
        REJECTED("gui.sfm.flow.tooltip.condition_rejected", false);

        public final String UNLOCALIZED_DISPLAY_NAME;
        public final boolean RESULT;

        private Result(String unlocalizedName, boolean result) {
            this.UNLOCALIZED_DISPLAY_NAME = unlocalizedName;
            this.RESULT = result;
        }
    }

    public static enum TileMode {
        MATCH_ALL,
        MATCH_ANY;

    }

    public static enum ItemMode {
        MATCH_ALL,
        MATCH_ANY;

    }
}

