/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.ItemInputFlowButton;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.core.PositionHolder;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.data.ItemMovementRuleFlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.flow.holder.FlowDataRemovedObserver;
import ca.teamdman.sfm.common.registrar.FlowDataSerializerRegistrar;
import ca.teamdman.sfm.common.tile.manager.ExecutionStep;
import ca.teamdman.sfm.common.util.SFMUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ItemInputFlowData
extends FlowData
implements Observer,
PositionHolder {
    private final FlowDataRemovedObserver OBSERVER;
    public Position position;
    public UUID tileEntityRule;

    public ItemInputFlowData(ItemInputFlowData other) {
        this(UUID.randomUUID(), other.position.copy(), other.tileEntityRule);
    }

    @Override
    public void execute(ExecutionStep step) {
        BasicFlowDataContainer container = step.TILE.getFlowDataContainer();
        container.get(this.tileEntityRule, ItemMovementRuleFlowData.class).ifPresent(step.INPUTS::add);
    }

    public ItemInputFlowData(UUID uuid, Position position, UUID tileEntityRule) {
        super(uuid);
        this.position = position;
        this.tileEntityRule = tileEntityRule;
        this.OBSERVER = new FlowDataRemovedObserver(this, data -> data.getId().equals(tileEntityRule), c -> c.remove(this.getId()));
    }

    @Override
    public void addToDataContainer(BasicFlowDataContainer container) {
        super.addToDataContainer(container);
        container.addObserver(this);
    }

    @Override
    public void removeFromDataContainer(BasicFlowDataContainer container) {
        super.removeFromDataContainer(container);
        container.get(this.tileEntityRule).ifPresent(data -> data.removeFromDataContainer(container));
    }

    @Override
    public ItemInputFlowData duplicate(BasicFlowDataContainer container, Consumer<FlowData> dependencyTracker) {
        ItemInputFlowData newInput = new ItemInputFlowData(this);
        container.get(newInput.tileEntityRule, ItemMovementRuleFlowData.class).ifPresent(data -> {
            FlowData newData = data.duplicate(container, (Consumer)dependencyTracker);
            dependencyTracker.accept(newData);
            newInput.tileEntityRule = newData.getId();
        });
        return newInput;
    }

    @Override
    public boolean isValidRelationshipTarget() {
        return true;
    }

    @Override
    public FlowComponent createController(FlowComponent parent) {
        if (parent instanceof ManagerFlowController) {
            return new ItemInputFlowButton((ManagerFlowController)parent, this, ((ManagerFlowController)parent).SCREEN.getFlowDataContainer().get(this.tileEntityRule, ItemMovementRuleFlowData.class).orElseGet(ItemMovementRuleFlowData::new));
        }
        return null;
    }

    @Override
    public Set<Class<?>> getDependencies() {
        return ImmutableSet.of(ItemMovementRuleFlowData.class);
    }

    public FlowDataSerializer<ItemInputFlowData> getSerializer() {
        return FlowDataSerializerRegistrar.FlowDataSerializers.BASIC_INPUT;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.OBSERVER.update(o, arg);
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    public static class Serializer
    extends FlowDataSerializer<ItemInputFlowData> {
        public Serializer(ResourceLocation key) {
            super(key);
        }

        @Override
        public ItemInputFlowData fromNBT(CompoundNBT tag) {
            return new ItemInputFlowData(Serializer.getUUID(tag), new Position(tag.func_74775_l("pos")), UUID.fromString(tag.func_74779_i("tileEntityRule")));
        }

        @Override
        public CompoundNBT toNBT(ItemInputFlowData data) {
            CompoundNBT tag = super.toNBT(data);
            tag.func_218657_a("pos", (INBT)data.position.serializeNBT());
            tag.func_74778_a("tileEntityRule", data.tileEntityRule.toString());
            return tag;
        }

        @Override
        public ItemInputFlowData fromBuffer(PacketBuffer buf) {
            return new ItemInputFlowData(SFMUtil.readUUID(buf), Position.fromLong(buf.readLong()), SFMUtil.readUUID(buf));
        }

        @Override
        public void toBuffer(ItemInputFlowData data, PacketBuffer buf) {
            SFMUtil.writeUUID(data.getId(), buf);
            buf.writeLong(data.position.toLong());
            SFMUtil.writeUUID(data.tileEntityRule, buf);
        }
    }
}

