/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.client.ItemStackSearchIndexer;
import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.ItemModMatcherFlowComponent;
import ca.teamdman.sfm.common.flow.core.ItemMatcher;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.data.ItemMovementRuleFlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.flow.holder.FlowDataHolderObserver;
import ca.teamdman.sfm.common.registrar.FlowDataSerializerRegistrar;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ItemModMatcherFlowData
extends FlowData
implements ItemMatcher {
    public String modId;
    public int quantity;
    public boolean open;
    private List<ItemStack> preview;

    public ItemModMatcherFlowData(ItemModMatcherFlowData other) {
        this(UUID.randomUUID(), other.modId, other.quantity, other.open);
    }

    public ItemModMatcherFlowData(UUID uuid, String modId, int quantity, boolean open) {
        super(uuid);
        this.modId = modId;
        this.quantity = quantity;
        this.open = open;
    }

    @Override
    public void addToDataContainer(BasicFlowDataContainer container) {
        super.addToDataContainer(container);
        container.addObserver(new FlowDataHolderObserver<ItemMovementRuleFlowData>(ItemMovementRuleFlowData.class, data -> data.itemMatcherIds.contains(this.getId()), data -> this.open &= data.open));
    }

    @Override
    public ItemModMatcherFlowData duplicate(BasicFlowDataContainer container, Consumer<FlowData> dependencyTracker) {
        return new ItemModMatcherFlowData(this);
    }

    @Override
    public FlowComponent createController(FlowComponent parent) {
        if (parent instanceof ManagerFlowController) {
            return new ItemModMatcherFlowComponent((ManagerFlowController)parent, this);
        }
        return null;
    }

    public FlowDataSerializer<ItemModMatcherFlowData> getSerializer() {
        return FlowDataSerializerRegistrar.FlowDataSerializers.ITEM_MOD_MATCHER;
    }

    @Override
    public boolean matches(@Nonnull ItemStack stack) {
        return stack.func_77973_b().getRegistryName().func_110624_b().equals(this.modId) && (this.quantity == 0 || stack.func_190916_E() >= this.quantity);
    }

    @Override
    public int getQuantity() {
        return this.quantity == 0 ? Integer.MAX_VALUE : this.quantity;
    }

    @Override
    public List<ItemStack> getPreview() {
        if (this.preview == null) {
            this.preview = ItemStackSearchIndexer.getSearchableItems().filter(this::matches).limit(100L).collect(Collectors.toList());
            return this.preview;
        }
        return this.preview;
    }

    @Override
    public String getMatcherDisplayName() {
        return I18n.func_135052_a((String)"gui.sfm.flow.tooltip.item_stack_mod_id_matcher", (Object[])new Object[0]);
    }

    public static class Serializer
    extends FlowDataSerializer<ItemModMatcherFlowData> {
        public Serializer(ResourceLocation registryName) {
            super(registryName);
        }

        @Override
        public ItemModMatcherFlowData fromNBT(CompoundNBT tag) {
            return new ItemModMatcherFlowData(Serializer.getUUID(tag), tag.func_74779_i("modId"), tag.func_74762_e("quantity"), tag.func_74767_n("open"));
        }

        @Override
        public CompoundNBT toNBT(ItemModMatcherFlowData data) {
            CompoundNBT tag = super.toNBT(data);
            tag.func_74768_a("quantity", data.quantity);
            tag.func_74778_a("modId", data.modId);
            tag.func_74757_a("open", data.open);
            return tag;
        }

        @Override
        public ItemModMatcherFlowData fromBuffer(PacketBuffer buf) {
            return new ItemModMatcherFlowData(SFMUtil.readUUID(buf), buf.func_150789_c(64), buf.readInt(), buf.readBoolean());
        }

        @Override
        public void toBuffer(ItemModMatcherFlowData data, PacketBuffer buf) {
            SFMUtil.writeUUID(data.getId(), buf);
            buf.func_211400_a(data.modId, 64);
            buf.writeInt(data.quantity);
            buf.writeBoolean(data.open);
        }
    }
}

