/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.itemmovementrule.ItemMovementRuleFlowComponent;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.flow.core.FlowDialog;
import ca.teamdman.sfm.common.flow.core.ItemMatcher;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.core.PositionHolder;
import ca.teamdman.sfm.common.flow.core.TileMatcher;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.flow.holder.FlowDataRemovedObserver;
import ca.teamdman.sfm.common.registrar.FlowDataSerializerRegistrar;
import ca.teamdman.sfm.common.tile.manager.ExecutionState;
import ca.teamdman.sfm.common.util.EnumSetSerializationHelper;
import ca.teamdman.sfm.common.util.SFMUtil;
import ca.teamdman.sfm.common.util.SlotsRule;
import ca.teamdman.sfm.common.util.UUIDList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemMovementRuleFlowData
extends FlowData
implements PositionHolder,
FlowDialog {
    public static final int MAX_NAME_LENGTH = 256;
    private final FlowDataRemovedObserver DATA_REMOVED_OBSERVER;
    public FilterMode filterMode;
    public String name;
    public ItemStack icon;
    public Position position;
    public UUIDList itemMatcherIds;
    public UUIDList tileMatcherIds;
    public EnumSet<Direction> faces;
    public SlotsRule slots;
    public boolean open;

    public ItemMovementRuleFlowData() {
        this(UUID.randomUUID(), I18n.func_135052_a((String)"gui.sfm.flow.placeholder.default_rule_name", (Object[])new Object[0]), ItemStack.field_190927_a, new Position(0, 0), FilterMode.WHITELIST, Collections.emptyList(), Collections.emptyList(), EnumSet.allOf(Direction.class), new SlotsRule(""), false);
    }

    public ItemMovementRuleFlowData(UUID uuid, String name, ItemStack icon, Position position, FilterMode filterMode, Collection<UUID> itemMatcherIds, Collection<UUID> tileMatcherIds, EnumSet<Direction> faces, SlotsRule slots, boolean open) {
        super(uuid);
        this.name = name;
        this.icon = icon;
        this.position = position;
        this.filterMode = filterMode;
        this.itemMatcherIds = new UUIDList((Collection<? extends UUID>)itemMatcherIds);
        this.faces = faces;
        this.slots = slots;
        this.open = open;
        this.DATA_REMOVED_OBSERVER = new FlowDataRemovedObserver(this, data -> this.itemMatcherIds.remove(data.getId()) || this.tileMatcherIds.remove(data.getId()));
        this.tileMatcherIds = new UUIDList((Collection<? extends UUID>)tileMatcherIds);
    }

    public ItemMovementRuleFlowData(ItemMovementRuleFlowData other) {
        this(UUID.randomUUID(), other.name, other.icon.func_77946_l(), other.position.copy(), other.filterMode, new UUIDList(other.itemMatcherIds), new UUIDList(other.tileMatcherIds), EnumSet.copyOf(other.faces), other.slots.copy(), other.open);
    }

    public Optional<ItemMatcher> getBestItemMatcher(BasicFlowDataContainer container, ItemStack stack, ExecutionState state) {
        return this.itemMatcherIds.stream().map(id -> container.get((UUID)id, ItemMatcher.class)).filter(Optional::isPresent).map(Optional::get).filter(m -> m.matches(stack)).max(Comparator.comparingInt(m -> state.getRemainingQuantity(this, (ItemMatcher)m)));
    }

    public List<IItemHandler> getItemHandlers(BasicFlowDataContainer container, CableNetwork network) {
        return this.getTiles(container, network).flatMap(tile -> this.faces.stream().map(face -> tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face))).filter(LazyOptional::isPresent).map(LazyOptional::resolve).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Stream<TileEntity> getTiles(BasicFlowDataContainer container, CableNetwork network) {
        List matchers = this.tileMatcherIds.stream().map(id -> container.get((UUID)id, TileMatcher.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        Predicate<TileEntity> matches = tile -> matchers.stream().anyMatch(m -> m.matches((TileEntity)tile));
        return network.getInventories().stream().filter(matches);
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void addToDataContainer(BasicFlowDataContainer container) {
        super.addToDataContainer(container);
        container.addObserver(this.DATA_REMOVED_OBSERVER);
    }

    @Override
    public void removeFromDataContainer(BasicFlowDataContainer container) {
        super.removeFromDataContainer(container);
        Stream.concat(this.itemMatcherIds.stream(), this.tileMatcherIds.stream()).map(container::get).filter(Optional::isPresent).map(Optional::get).forEach(data -> data.removeFromDataContainer(container));
    }

    @Override
    public ItemMovementRuleFlowData duplicate(BasicFlowDataContainer container, Consumer<FlowData> dependencyTracker) {
        ItemMovementRuleFlowData newRule = new ItemMovementRuleFlowData(this);
        dependencyTracker.accept(newRule);
        newRule.itemMatcherIds.clear();
        this.itemMatcherIds.stream().map(container::get).filter(Optional::isPresent).map(Optional::get).filter(ItemMatcher.class::isInstance).map(data -> data.duplicate(container, dependencyTracker)).peek(dependencyTracker).map(FlowData::getId).forEach(newRule.itemMatcherIds::add);
        newRule.tileMatcherIds.clear();
        this.tileMatcherIds.stream().map(container::get).filter(Optional::isPresent).map(Optional::get).filter(TileMatcher.class::isInstance).map(data -> data.duplicate(container, dependencyTracker)).peek(dependencyTracker).map(FlowData::getId).forEach(newRule.tileMatcherIds::add);
        return newRule;
    }

    @Override
    public FlowComponent createController(FlowComponent parent) {
        if (!(parent instanceof ManagerFlowController)) {
            return null;
        }
        return new ItemMovementRuleFlowComponent((ManagerFlowController)parent, this);
    }

    @Override
    public Set<Class<?>> getDependencies() {
        return ImmutableSet.of(ItemMatcher.class, TileMatcher.class);
    }

    public FlowDataSerializer<ItemMovementRuleFlowData> getSerializer() {
        return FlowDataSerializerRegistrar.FlowDataSerializers.ITEM_MOVEMENT_RULE;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void setOpen(boolean value) {
        this.open = value;
    }

    public static class Serializer
    extends FlowDataSerializer<ItemMovementRuleFlowData> {
        public Serializer(ResourceLocation registryName) {
            super(registryName);
        }

        @Override
        public ItemMovementRuleFlowData fromNBT(CompoundNBT tag) {
            return new ItemMovementRuleFlowData(Serializer.getUUID(tag), tag.func_74779_i("name"), ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("icon")), new Position(tag.func_74775_l("pos")), FilterMode.valueOf(tag.func_74779_i("filterMode")), new UUIDList(tag, "itemMatchers"), new UUIDList(tag, "tileMatchers"), EnumSetSerializationHelper.deserialize(tag, "faces", Direction::valueOf), new SlotsRule(tag.func_74779_i("slots")), tag.func_74767_n("open"));
        }

        @Override
        public CompoundNBT toNBT(ItemMovementRuleFlowData data) {
            CompoundNBT tag = super.toNBT(data);
            tag.func_74778_a("name", data.name);
            tag.func_218657_a("icon", (INBT)data.icon.serializeNBT());
            tag.func_218657_a("pos", (INBT)data.position.serializeNBT());
            tag.func_74778_a("filterMode", data.filterMode.name());
            tag.func_218657_a("itemMatchers", (INBT)data.itemMatcherIds.serialize());
            tag.func_218657_a("tileMatchers", (INBT)data.tileMatcherIds.serialize());
            tag.func_218657_a("faces", (INBT)EnumSetSerializationHelper.serialize(data.faces));
            tag.func_74778_a("slots", data.slots.getDefinition());
            tag.func_74757_a("open", data.open);
            return tag;
        }

        @Override
        public ItemMovementRuleFlowData fromBuffer(PacketBuffer buf) {
            return new ItemMovementRuleFlowData(SFMUtil.readUUID(buf), buf.func_150789_c(256), buf.func_150791_c(), Position.fromLong(buf.readLong()), FilterMode.valueOf(buf.func_150789_c(16)), new UUIDList(buf), new UUIDList(buf), EnumSetSerializationHelper.deserialize(buf, Direction::valueOf, Direction.class), new SlotsRule(buf.func_150789_c(32)), buf.readBoolean());
        }

        @Override
        public void toBuffer(ItemMovementRuleFlowData data, PacketBuffer buf) {
            SFMUtil.writeUUID(data.getId(), buf);
            buf.func_211400_a(data.name, 256);
            buf.func_150788_a(data.icon);
            buf.writeLong(data.position.toLong());
            buf.func_211400_a(data.filterMode.name(), 16);
            data.itemMatcherIds.serialize(buf);
            data.tileMatcherIds.serialize(buf);
            EnumSetSerializationHelper.serialize(data.faces, buf);
            buf.func_211400_a(data.slots.getDefinition(), 32);
            buf.writeBoolean(data.open);
        }
    }

    public static enum FilterMode {
        WHITELIST,
        BLACKLIST;

    }
}

