/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.ItemOutputFlowButton;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.flow.core.ItemMatcher;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.core.PositionHolder;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.data.ItemMovementRuleFlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.flow.holder.FlowDataRemovedObserver;
import ca.teamdman.sfm.common.registrar.FlowDataSerializerRegistrar;
import ca.teamdman.sfm.common.tile.manager.ExecutionStep;
import ca.teamdman.sfm.common.util.SFMUtil;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;

public class ItemOutputFlowData
extends FlowData
implements Observer,
PositionHolder {
    private final FlowDataRemovedObserver OBSERVER;
    public Position position;
    public UUID tileEntityRule;

    public ItemOutputFlowData(ItemOutputFlowData other) {
        this(UUID.randomUUID(), other.position.copy(), other.tileEntityRule);
    }

    public ItemOutputFlowData(UUID uuid, Position position, UUID tileEntityRule) {
        super(uuid);
        this.position = position;
        this.tileEntityRule = tileEntityRule;
        this.OBSERVER = new FlowDataRemovedObserver(this, data -> data.getId().equals(tileEntityRule), c -> c.remove(this.getId()));
    }

    @Override
    public void addToDataContainer(BasicFlowDataContainer container) {
        super.addToDataContainer(container);
        container.addObserver(this);
    }

    @Override
    public void removeFromDataContainer(BasicFlowDataContainer container) {
        super.removeFromDataContainer(container);
        container.get(this.tileEntityRule).ifPresent(data -> data.removeFromDataContainer(container));
    }

    @Override
    public void execute(ExecutionStep step) {
        BasicFlowDataContainer container = step.TILE.getFlowDataContainer();
        CableNetworkManager.getOrRegisterNetwork(step.TILE).ifPresent(network -> container.get(this.tileEntityRule, ItemMovementRuleFlowData.class).ifPresent(rule -> this.satisfyOutput(step, (CableNetwork)network, (ItemMovementRuleFlowData)rule)));
    }

    private void satisfyOutput(ExecutionStep step, CableNetwork network, ItemMovementRuleFlowData outRule) {
        BasicFlowDataContainer dataContainer = step.TILE.getFlowDataContainer();
        List<IItemHandler> outHandlers = outRule.getItemHandlers(dataContainer, network);
        for (ItemMovementRuleFlowData inRule : step.INPUTS) {
            for (IItemHandler inHandler : inRule.getItemHandlers(dataContainer, network)) {
                block2: for (int inSlot : inRule.slots.getSlots(inHandler.getSlots()).toArray()) {
                    ItemStack stack = inHandler.getStackInSlot(inSlot);
                    if (stack.func_190926_b()) continue;
                    ItemMatcher inMatcher = inRule.getBestItemMatcher(dataContainer, stack, step.STATE).orElse(null);
                    ItemMatcher outMatcher = outRule.getBestItemMatcher(dataContainer, stack, step.STATE).orElse(null);
                    int allowedToExtract = step.STATE.getRemainingQuantity(inRule, inMatcher);
                    int allowedToInsert = step.STATE.getRemainingQuantity(outRule, outMatcher);
                    if (allowedToExtract == 0 || allowedToInsert == 0) continue;
                    int remainingQuantity = Math.max(0, Math.min(allowedToExtract, allowedToInsert));
                    int previous = -1;
                    while (remainingQuantity > 0 && previous != remainingQuantity) {
                        previous = remainingQuantity;
                        for (IItemHandler outHandler : outHandlers) {
                            for (int outSlot : outRule.slots.getSlots(outHandler.getSlots()).toArray()) {
                                ItemStack extracted = inHandler.extractItem(inSlot, remainingQuantity, true);
                                if (extracted.func_190926_b()) continue block2;
                                ItemStack leftoverStack = outHandler.insertItem(outSlot, extracted, true);
                                int toTransfer = extracted.func_190916_E() - leftoverStack.func_190916_E();
                                extracted = inHandler.extractItem(inSlot, toTransfer, false);
                                leftoverStack = outHandler.insertItem(outSlot, extracted, false);
                                remainingQuantity -= toTransfer;
                                step.STATE.recordUsage(inMatcher, toTransfer);
                                step.STATE.recordUsage(outMatcher, toTransfer);
                                if (leftoverStack.func_190926_b()) continue;
                                SFM.LOGGER.warn(SFMUtil.getMarker(this.getClass()), "Failed to fully insert stack {}, remaining {} will be voided", (Object)extracted, (Object)leftoverStack);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public ItemOutputFlowData duplicate(BasicFlowDataContainer container, Consumer<FlowData> dependencyTracker) {
        ItemOutputFlowData newOutput = new ItemOutputFlowData(this);
        container.get(newOutput.tileEntityRule, ItemMovementRuleFlowData.class).ifPresent(data -> {
            FlowData newData = data.duplicate(container, (Consumer)dependencyTracker);
            dependencyTracker.accept(newData);
            newOutput.tileEntityRule = newData.getId();
        });
        return newOutput;
    }

    @Override
    public boolean isValidRelationshipTarget() {
        return true;
    }

    @Override
    public FlowComponent createController(FlowComponent parent) {
        if (parent instanceof ManagerFlowController) {
            return new ItemOutputFlowButton((ManagerFlowController)parent, this, ((ManagerFlowController)parent).SCREEN.getFlowDataContainer().get(this.tileEntityRule, ItemMovementRuleFlowData.class).orElseGet(ItemMovementRuleFlowData::new));
        }
        return null;
    }

    @Override
    public Set<Class<?>> getDependencies() {
        return ImmutableSet.of(ItemMovementRuleFlowData.class);
    }

    public FlowDataSerializer<ItemOutputFlowData> getSerializer() {
        return FlowDataSerializerRegistrar.FlowDataSerializers.BASIC_OUTPUT;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.OBSERVER.update(o, arg);
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    public static class Serializer
    extends FlowDataSerializer<ItemOutputFlowData> {
        public Serializer(ResourceLocation key) {
            super(key);
        }

        @Override
        public ItemOutputFlowData fromNBT(CompoundNBT tag) {
            return new ItemOutputFlowData(Serializer.getUUID(tag), new Position(tag.func_74775_l("pos")), UUID.fromString(tag.func_74779_i("tileEntityRule")));
        }

        @Override
        public CompoundNBT toNBT(ItemOutputFlowData data) {
            CompoundNBT tag = super.toNBT(data);
            tag.func_218657_a("pos", (INBT)data.position.serializeNBT());
            tag.func_74778_a("tileEntityRule", data.tileEntityRule.toString());
            return tag;
        }

        @Override
        public ItemOutputFlowData fromBuffer(PacketBuffer buf) {
            return new ItemOutputFlowData(SFMUtil.readUUID(buf), Position.fromLong(buf.readLong()), SFMUtil.readUUID(buf));
        }

        @Override
        public void toBuffer(ItemOutputFlowData data, PacketBuffer buf) {
            SFMUtil.writeUUID(data.getId(), buf);
            buf.writeLong(data.position.toLong());
            SFMUtil.writeUUID(data.tileEntityRule, buf);
        }
    }
}

