/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.itempickermatcher.ItemPickerMatcherFlowComponent;
import ca.teamdman.sfm.common.flow.core.ItemMatcher;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.data.ItemMovementRuleFlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.flow.holder.FlowDataHolderObserver;
import ca.teamdman.sfm.common.registrar.FlowDataSerializerRegistrar;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ItemPickerMatcherFlowData
extends FlowData
implements ItemMatcher {
    public ItemStack stack;
    public int quantity;
    public boolean open;

    public ItemPickerMatcherFlowData(ItemPickerMatcherFlowData other) {
        this(UUID.randomUUID(), other.stack.func_77946_l(), other.quantity, other.open);
    }

    public ItemPickerMatcherFlowData(UUID uuid, ItemStack stack, int quantity, boolean open) {
        super(uuid);
        this.stack = stack;
        this.quantity = quantity;
        this.open = open;
    }

    @Override
    public void addToDataContainer(BasicFlowDataContainer container) {
        super.addToDataContainer(container);
        container.addObserver(new FlowDataHolderObserver<ItemMovementRuleFlowData>(ItemMovementRuleFlowData.class, data -> data.itemMatcherIds.contains(this.getId()), data -> this.open &= data.open));
    }

    @Override
    public ItemPickerMatcherFlowData duplicate(BasicFlowDataContainer container, Consumer<FlowData> dependencyTracker) {
        return new ItemPickerMatcherFlowData(this);
    }

    @Override
    public FlowComponent createController(FlowComponent parent) {
        if (parent instanceof ManagerFlowController) {
            return new ItemPickerMatcherFlowComponent((ManagerFlowController)parent, this);
        }
        return null;
    }

    public FlowDataSerializer<ItemPickerMatcherFlowData> getSerializer() {
        return FlowDataSerializerRegistrar.FlowDataSerializers.ITEM_PICKER_MATCHER;
    }

    @Override
    public boolean matches(@Nonnull ItemStack stack) {
        return this.stack.func_77969_a(stack) && (this.quantity == 0 || stack.func_190916_E() >= this.quantity);
    }

    @Override
    public int getQuantity() {
        return this.quantity == 0 ? Integer.MAX_VALUE : this.quantity;
    }

    @Override
    public List<ItemStack> getPreview() {
        return Collections.singletonList(this.stack);
    }

    @Override
    public String getMatcherDisplayName() {
        return I18n.func_135052_a((String)"gui.sfm.flow.tooltip.item_stack_comparer_matcher", (Object[])new Object[0]);
    }

    public static class Serializer
    extends FlowDataSerializer<ItemPickerMatcherFlowData> {
        public Serializer(ResourceLocation registryName) {
            super(registryName);
        }

        @Override
        public ItemPickerMatcherFlowData fromNBT(CompoundNBT tag) {
            return new ItemPickerMatcherFlowData(Serializer.getUUID(tag), ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("stack")), tag.func_74762_e("quantity"), tag.func_74767_n("open"));
        }

        @Override
        public CompoundNBT toNBT(ItemPickerMatcherFlowData data) {
            CompoundNBT tag = super.toNBT(data);
            tag.func_74768_a("quantity", data.quantity);
            tag.func_218657_a("stack", (INBT)data.stack.serializeNBT());
            tag.func_74757_a("open", data.open);
            return tag;
        }

        @Override
        public ItemPickerMatcherFlowData fromBuffer(PacketBuffer buf) {
            return new ItemPickerMatcherFlowData(SFMUtil.readUUID(buf), buf.func_150791_c(), buf.readInt(), buf.readBoolean());
        }

        @Override
        public void toBuffer(ItemPickerMatcherFlowData data, PacketBuffer buf) {
            SFMUtil.writeUUID(data.getId(), buf);
            buf.func_150788_a(data.stack);
            buf.writeInt(data.quantity);
            buf.writeBoolean(data.open);
        }
    }
}

