/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.FlowLineNode;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.core.PositionHolder;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.registrar.FlowDataSerializerRegistrar;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.Observable;
import java.util.Observer;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class LineNodeFlowData
extends FlowData
implements Observer,
PositionHolder {
    public Position position;

    public LineNodeFlowData(LineNodeFlowData other) {
        this(UUID.randomUUID(), other.position.copy());
    }

    public LineNodeFlowData(UUID uuid, Position position) {
        super(uuid);
        this.position = position;
    }

    @Override
    public void addToDataContainer(BasicFlowDataContainer container) {
        super.addToDataContainer(container);
        container.addObserver(this);
    }

    @Override
    public LineNodeFlowData duplicate(BasicFlowDataContainer container, Consumer<FlowData> dependencyTracker) {
        return new LineNodeFlowData(this);
    }

    @Override
    public boolean isValidRelationshipTarget() {
        return true;
    }

    @Override
    public FlowComponent createController(FlowComponent parent) {
        if (!(parent instanceof ManagerFlowController)) {
            return null;
        }
        return new FlowLineNode((ManagerFlowController)parent, this);
    }

    public FlowDataSerializer<LineNodeFlowData> getSerializer() {
        return FlowDataSerializerRegistrar.FlowDataSerializers.LINE_NODE;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof BasicFlowDataContainer.FlowDataContainerChange && o instanceof BasicFlowDataContainer) {
            BasicFlowDataContainer.FlowDataContainerChange change = (BasicFlowDataContainer.FlowDataContainerChange)arg;
            BasicFlowDataContainer container = (BasicFlowDataContainer)o;
            if (!(change.CHANGE != BasicFlowDataContainer.FlowDataContainerChange.ChangeType.REMOVED || container.getAncestors(this.getId(), false).findAny().isPresent() && container.getDescendants(this.getId(), false).findAny().isPresent())) {
                container.remove(this.getId());
                o.deleteObserver(this);
            }
        }
    }

    public static class Serializer
    extends FlowDataSerializer<LineNodeFlowData> {
        public Serializer(ResourceLocation key) {
            super(key);
        }

        @Override
        public LineNodeFlowData fromNBT(CompoundNBT tag) {
            return new LineNodeFlowData(Serializer.getUUID(tag), new Position(tag.func_74775_l("pos")));
        }

        @Override
        public CompoundNBT toNBT(LineNodeFlowData data) {
            CompoundNBT tag = super.toNBT(data);
            tag.func_218657_a("pos", (INBT)data.position.serializeNBT());
            return tag;
        }

        @Override
        public LineNodeFlowData fromBuffer(PacketBuffer buf) {
            return new LineNodeFlowData(SFMUtil.readUUID(buf), Position.fromLong(buf.readLong()));
        }

        @Override
        public void toBuffer(LineNodeFlowData data, PacketBuffer buf) {
            SFMUtil.writeUUID(data.getId(), buf);
            buf.writeLong(data.position.toLong());
        }
    }
}

