/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.FlowRelationship;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.registrar.FlowDataSerializerRegistrar;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class RelationshipFlowData
extends FlowData
implements Observer {
    public UUID from;
    public UUID to;

    public RelationshipFlowData(UUID from, UUID to) {
        this(UUID.randomUUID(), from, to);
    }

    public RelationshipFlowData(UUID uuid, UUID from, UUID to) {
        super(uuid);
        this.from = from;
        this.to = to;
    }

    public RelationshipFlowData(RelationshipFlowData other) {
        this(UUID.randomUUID(), other.from, other.to);
    }

    @Override
    public void addToDataContainer(BasicFlowDataContainer container) {
        if (this.from == null || this.to == null) {
            return;
        }
        if (this.from.equals(this.to)) {
            return;
        }
        if (container.getDescendants(this.to, true).anyMatch(this.from::equals)) {
            return;
        }
        if (container.getDescendants(this.from, false).anyMatch(this.to::equals)) {
            container.removeIf(data -> data instanceof RelationshipFlowData && this.isSimilar((RelationshipFlowData)data, container));
            return;
        }
        super.addToDataContainer(container);
        container.addObserver(this);
    }

    public boolean isSimilar(RelationshipFlowData other, BasicFlowDataContainer container) {
        if (!other.from.equals(this.from)) {
            return false;
        }
        return container.getDescendants(other.from, false).anyMatch(this.to::equals);
    }

    @Override
    public RelationshipFlowData duplicate(BasicFlowDataContainer container, Consumer<FlowData> dependencyTracker) {
        return new RelationshipFlowData(this);
    }

    @Override
    public FlowComponent createController(FlowComponent parent) {
        if (!(parent instanceof ManagerFlowController)) {
            return null;
        }
        return new FlowRelationship((ManagerFlowController)parent, this);
    }

    public FlowDataSerializer<RelationshipFlowData> getSerializer() {
        return FlowDataSerializerRegistrar.FlowDataSerializers.RELATIONSHIP;
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof BasicFlowDataContainer.FlowDataContainerChange && o instanceof BasicFlowDataContainer) {
            BasicFlowDataContainer.FlowDataContainerChange change = (BasicFlowDataContainer.FlowDataContainerChange)arg;
            BasicFlowDataContainer container = (BasicFlowDataContainer)o;
            if (change.CHANGE == BasicFlowDataContainer.FlowDataContainerChange.ChangeType.REMOVED && (change.DATA.getId().equals(this.from) || change.DATA.getId().equals(this.to))) {
                container.remove(this.getId());
                o.deleteObserver(this);
            }
        }
    }

    public static class Serializer
    extends FlowDataSerializer<RelationshipFlowData> {
        public Serializer(ResourceLocation registryName) {
            super(registryName);
        }

        @Override
        public RelationshipFlowData fromNBT(CompoundNBT tag) {
            return new RelationshipFlowData(Serializer.getUUID(tag), UUID.fromString(tag.func_74779_i("from")), UUID.fromString(tag.func_74779_i("to")));
        }

        @Override
        public CompoundNBT toNBT(RelationshipFlowData data) {
            CompoundNBT tag = super.toNBT(data);
            tag.func_74778_a("from", data.from.toString());
            tag.func_74778_a("to", data.to.toString());
            return tag;
        }

        @Override
        public RelationshipFlowData fromBuffer(PacketBuffer buf) {
            return new RelationshipFlowData(SFMUtil.readUUID(buf), SFMUtil.readUUID(buf), SFMUtil.readUUID(buf));
        }

        @Override
        public void toBuffer(RelationshipFlowData data, PacketBuffer buf) {
            SFMUtil.writeUUID(data.getId(), buf);
            SFMUtil.writeUUID(data.from, buf);
            SFMUtil.writeUUID(data.to, buf);
        }
    }
}

