/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.TileModMatcherFlowComponent;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.flow.core.TileMatcher;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.data.ItemMovementRuleFlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.flow.holder.FlowDataHolderObserver;
import ca.teamdman.sfm.common.registrar.FlowDataSerializerRegistrar;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class TileModMatcherFlowData
extends FlowData
implements TileMatcher {
    public String modId;
    public boolean open;
    private transient List<ItemStack> preview;

    public TileModMatcherFlowData(TileModMatcherFlowData other) {
        this(UUID.randomUUID(), other.modId, other.open);
    }

    public TileModMatcherFlowData(UUID uuid, String modId, boolean open) {
        super(uuid);
        this.modId = modId;
        this.open = open;
    }

    @Override
    public void addToDataContainer(BasicFlowDataContainer container) {
        super.addToDataContainer(container);
        container.addObserver(new FlowDataHolderObserver<ItemMovementRuleFlowData>(ItemMovementRuleFlowData.class, data -> data.itemMatcherIds.contains(this.getId()), data -> this.open &= data.open));
    }

    @Override
    public TileModMatcherFlowData duplicate(BasicFlowDataContainer container, Consumer<FlowData> dependencyTracker) {
        return new TileModMatcherFlowData(this);
    }

    @Override
    public FlowComponent createController(FlowComponent parent) {
        if (parent instanceof ManagerFlowController) {
            return new TileModMatcherFlowComponent((ManagerFlowController)parent, this);
        }
        return null;
    }

    public FlowDataSerializer<TileModMatcherFlowData> getSerializer() {
        return FlowDataSerializerRegistrar.FlowDataSerializers.TILE_MOD_MATCHER;
    }

    @Override
    public boolean matches(@Nonnull TileEntity tile) {
        return tile.func_200662_C().getRegistryName().func_110624_b().equals(this.modId);
    }

    @Override
    public List<ItemStack> getPreview(CableNetwork network) {
        if (this.preview == null) {
            this.preview = network.getInventories().stream().filter(this::matches).map(TileEntity::func_174877_v).map(network::getPreview).collect(Collectors.toList());
            return this.preview;
        }
        return this.preview;
    }

    @Override
    public List<? extends ITextProperties> getTooltip(List<? extends ITextProperties> normal) {
        ArrayList<? extends ITextProperties> rtn = new ArrayList<ITextProperties>(normal);
        rtn.add(1, (ITextProperties)new StringTextComponent(I18n.func_135052_a((String)"gui.sfm.flow.tooltip.tile_mod_matcher", (Object[])new Object[0])).func_240699_a_(TextFormatting.GRAY));
        rtn.add(2, (ITextProperties)new StringTextComponent(this.modId).func_240699_a_(TextFormatting.GRAY));
        return rtn;
    }

    @Override
    public boolean isVisible() {
        return this.open;
    }

    @Override
    public void setVisibility(boolean open) {
        this.open = open;
    }

    public static class Serializer
    extends FlowDataSerializer<TileModMatcherFlowData> {
        public Serializer(ResourceLocation registryName) {
            super(registryName);
        }

        @Override
        public TileModMatcherFlowData fromNBT(CompoundNBT tag) {
            return new TileModMatcherFlowData(Serializer.getUUID(tag), tag.func_74779_i("modId"), tag.func_74767_n("open"));
        }

        @Override
        public CompoundNBT toNBT(TileModMatcherFlowData data) {
            CompoundNBT tag = super.toNBT(data);
            tag.func_74778_a("modId", data.modId);
            tag.func_74757_a("open", data.open);
            return tag;
        }

        @Override
        public TileModMatcherFlowData fromBuffer(PacketBuffer buf) {
            return new TileModMatcherFlowData(SFMUtil.readUUID(buf), buf.func_150789_c(64), buf.readBoolean());
        }

        @Override
        public void toBuffer(TileModMatcherFlowData data, PacketBuffer buf) {
            SFMUtil.writeUUID(data.getId(), buf);
            buf.func_211400_a(data.modId, 64);
            buf.writeBoolean(data.open);
        }
    }
}

