/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.tilepositionmatcher.TilePositionMatcherFlowComponent;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.flow.core.TileMatcher;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.data.ItemMovementRuleFlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.flow.holder.FlowDataHolderObserver;
import ca.teamdman.sfm.common.registrar.FlowDataSerializerRegistrar;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class TilePositionMatcherFlowData
extends FlowData
implements TileMatcher {
    public BlockPos position;
    public boolean open;
    private transient List<ItemStack> previewCache;

    public TilePositionMatcherFlowData(TilePositionMatcherFlowData other) {
        this(UUID.randomUUID(), other.position, false);
    }

    public TilePositionMatcherFlowData(UUID uuid, BlockPos position, boolean open) {
        super(uuid);
        this.position = position;
        this.open = open;
    }

    @Override
    public boolean matches(@Nonnull TileEntity tile) {
        return Objects.equals(tile.func_174877_v(), this.position);
    }

    @Override
    public List<ItemStack> getPreview(CableNetwork network) {
        if (this.previewCache == null) {
            this.previewCache = network.containsNeighbour(this.position) ? Collections.singletonList(network.getPreview(this.position)) : Collections.singletonList(new ItemStack((IItemProvider)Blocks.field_180401_cv));
        }
        return this.previewCache;
    }

    @Override
    public void addToDataContainer(BasicFlowDataContainer container) {
        super.addToDataContainer(container);
        container.addObserver(new FlowDataHolderObserver<ItemMovementRuleFlowData>(ItemMovementRuleFlowData.class, data -> data.tileMatcherIds.contains(this.getId()), data -> this.open &= data.open));
    }

    @Override
    public List<? extends ITextProperties> getTooltip(List<? extends ITextProperties> normal) {
        ArrayList<? extends ITextProperties> rtn = new ArrayList<ITextProperties>(normal);
        rtn.add(1, (ITextProperties)new StringTextComponent(I18n.func_135052_a((String)"gui.sfm.flow.tooltip.tile_position_matcher", (Object[])new Object[0])).func_240699_a_(TextFormatting.GRAY));
        rtn.add(2, (ITextProperties)new StringTextComponent(I18n.func_135052_a((String)"gui.sfm.flow.tooltip.block_pos", (Object[])new Object[]{this.position.func_177958_n(), this.position.func_177956_o(), this.position.func_177952_p()})).func_240699_a_(TextFormatting.GRAY));
        return rtn;
    }

    @Override
    public FlowData duplicate(BasicFlowDataContainer container, Consumer<FlowData> dependencyTracker) {
        return new TilePositionMatcherFlowData(this);
    }

    @Override
    @Nullable
    public FlowComponent createController(FlowComponent parent) {
        if (parent instanceof ManagerFlowController) {
            return new TilePositionMatcherFlowComponent((ManagerFlowController)parent, this);
        }
        return null;
    }

    public FlowDataSerializer<TilePositionMatcherFlowData> getSerializer() {
        return FlowDataSerializerRegistrar.FlowDataSerializers.TILE_POSITION_MATCHER;
    }

    @Override
    public boolean isVisible() {
        return this.open;
    }

    @Override
    public void setVisibility(boolean open) {
        this.open = open;
    }

    public static class Serializer
    extends FlowDataSerializer<TilePositionMatcherFlowData> {
        public Serializer(ResourceLocation registryName) {
            super(registryName);
        }

        @Override
        public TilePositionMatcherFlowData fromNBT(CompoundNBT tag) {
            return new TilePositionMatcherFlowData(Serializer.getUUID(tag), NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("pos")), tag.func_74767_n("open"));
        }

        @Override
        public CompoundNBT toNBT(TilePositionMatcherFlowData data) {
            CompoundNBT tag = super.toNBT(data);
            tag.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)data.position));
            tag.func_74757_a("open", data.open);
            return tag;
        }

        @Override
        public TilePositionMatcherFlowData fromBuffer(PacketBuffer buf) {
            return new TilePositionMatcherFlowData(SFMUtil.readUUID(buf), BlockPos.func_218283_e((long)buf.readLong()), buf.readBoolean());
        }

        @Override
        public void toBuffer(TilePositionMatcherFlowData data, PacketBuffer buf) {
            SFMUtil.writeUUID(data.getId(), buf);
            buf.writeLong(data.position.func_218275_a());
            buf.writeBoolean(data.open);
        }
    }
}

