/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.data;

import ca.teamdman.sfm.client.gui.flow.core.FlowComponent;
import ca.teamdman.sfm.client.gui.flow.impl.manager.core.ManagerFlowController;
import ca.teamdman.sfm.client.gui.flow.impl.manager.flowdataholder.timertrigger.TimerTriggerFlowComponent;
import ca.teamdman.sfm.common.flow.core.Position;
import ca.teamdman.sfm.common.flow.core.PositionHolder;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.registrar.FlowDataSerializerRegistrar;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class TimerTriggerFlowData
extends FlowData
implements PositionHolder {
    public Position position;
    public int interval;
    public boolean open;

    public TimerTriggerFlowData(TimerTriggerFlowData other) {
        this(UUID.randomUUID(), other.position.copy(), other.interval, other.open);
    }

    public TimerTriggerFlowData(UUID uuid, Position position, int interval, boolean open) {
        super(uuid);
        this.position = position;
        this.interval = Math.max(20, interval);
        this.open = open;
    }

    @Override
    public TimerTriggerFlowData duplicate(BasicFlowDataContainer container, Consumer<FlowData> dependencyTracker) {
        return new TimerTriggerFlowData(this);
    }

    @Override
    public boolean isValidRelationshipTarget() {
        return true;
    }

    @Override
    public FlowComponent createController(FlowComponent parent) {
        if (!(parent instanceof ManagerFlowController)) {
            return null;
        }
        return new TimerTriggerFlowComponent((ManagerFlowController)parent, this);
    }

    public FlowDataSerializer<TimerTriggerFlowData> getSerializer() {
        return FlowDataSerializerRegistrar.FlowDataSerializers.TIMER_TRIGGER;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    public static class Serializer
    extends FlowDataSerializer<TimerTriggerFlowData> {
        public Serializer(ResourceLocation key) {
            super(key);
        }

        @Override
        public TimerTriggerFlowData fromNBT(CompoundNBT tag) {
            return new TimerTriggerFlowData(Serializer.getUUID(tag), new Position(tag.func_74775_l("pos")), tag.func_74762_e("interval"), tag.func_74767_n("open"));
        }

        @Override
        public CompoundNBT toNBT(TimerTriggerFlowData data) {
            CompoundNBT tag = super.toNBT(data);
            tag.func_218657_a("pos", (INBT)data.position.serializeNBT());
            tag.func_74768_a("interval", data.interval);
            tag.func_74757_a("open", data.open);
            return tag;
        }

        @Override
        public TimerTriggerFlowData fromBuffer(PacketBuffer buf) {
            return new TimerTriggerFlowData(SFMUtil.readUUID(buf), Position.fromLong(buf.readLong()), buf.readInt(), buf.readBoolean());
        }

        @Override
        public void toBuffer(TimerTriggerFlowData data, PacketBuffer buf) {
            SFMUtil.writeUUID(data.getId(), buf);
            buf.writeLong(data.position.toLong());
            buf.writeInt(data.interval);
            buf.writeBoolean(data.open);
        }
    }
}

